/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.ape.calculation.findPvalue;

import gnu.trove.map.TDoubleDoubleMap;
import ru.autosome.ape.calculation.findPvalue.CanFindPvalue;
import ru.autosome.ape.model.exception.HashOverflowException;
import ru.autosome.commons.backgroundModel.GeneralizedBackgroundModel;
import ru.autosome.commons.cli.OutputInformation;
import ru.autosome.commons.model.Discretizer;
import ru.autosome.commons.motifModel.Discretable;
import ru.autosome.commons.motifModel.HasLength;
import ru.autosome.perfectosape.calculation.ScoringModelDistributions.ScoringModelDistributions;

public abstract class FindPvalueByDiscretization<ModelType extends Discretable<ModelType> & HasLength, BackgroundType extends GeneralizedBackgroundModel>
implements CanFindPvalue {
    final Discretizer discretizer;
    final ModelType motif;
    final BackgroundType background;

    abstract ScoringModelDistributions discretedScoringModel();

    FindPvalueByDiscretization(ModelType motif, BackgroundType background, Discretizer discretizer) {
        this.motif = motif;
        this.background = background;
        this.discretizer = discretizer;
    }

    CanFindPvalue.PvalueInfo infos_by_count(TDoubleDoubleMap counts, double non_upscaled_threshold) {
        double count = counts.get(this.discretizer.upscale(non_upscaled_threshold));
        double vocabularyVolume = Math.pow(this.background.volume(), ((HasLength)this.motif).length());
        double pvalue = count / vocabularyVolume;
        return new CanFindPvalue.PvalueInfo(non_upscaled_threshold, pvalue);
    }

    @Override
    public CanFindPvalue.PvalueInfo[] pvaluesByThresholds(double[] thresholds) throws HashOverflowException {
        TDoubleDoubleMap counts = this.discretedScoringModel().counts_above_thresholds(this.discretizer.upscale(thresholds));
        CanFindPvalue.PvalueInfo[] infos = new CanFindPvalue.PvalueInfo[thresholds.length];
        for (int i = 0; i < thresholds.length; ++i) {
            infos[i] = this.infos_by_count(counts, thresholds[i]);
        }
        return infos;
    }

    @Override
    public CanFindPvalue.PvalueInfo pvalueByThreshold(double threshold) throws HashOverflowException {
        double[] thresholds = new double[]{threshold};
        return this.pvaluesByThresholds(thresholds)[0];
    }

    @Override
    public OutputInformation report_table_layout() {
        OutputInformation infos = new OutputInformation();
        infos.add_parameter("V", "discretization value", this.discretizer);
        infos.background_parameter("B", "background", (GeneralizedBackgroundModel)this.background);
        infos.add_table_parameter("T", "threshold", "threshold");
        if (this.background.is_wordwise()) {
            infos.add_table_parameter("W", "number of recognized words", "numberOfRecognizedWords", new OutputInformation.Callback<CanFindPvalue.PvalueInfo>(){

                @Override
                public Object run(CanFindPvalue.PvalueInfo cell) {
                    double numberOfRecognizedWords = cell.numberOfRecognizedWords((GeneralizedBackgroundModel)FindPvalueByDiscretization.this.background, ((HasLength)FindPvalueByDiscretization.this.motif).length());
                    return (long)numberOfRecognizedWords;
                }
            });
        }
        infos.add_table_parameter("P", "P-value", "pvalue");
        return infos;
    }
}

