/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.ape.cli.generalized;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import ru.autosome.ape.calculation.PrecalculateThresholdList;
import ru.autosome.ape.model.PvalueBsearchList;
import ru.autosome.ape.model.exception.HashOverflowException;
import ru.autosome.ape.model.progression.Progression;
import ru.autosome.commons.backgroundModel.GeneralizedBackgroundModel;
import ru.autosome.commons.model.BoundaryType;
import ru.autosome.commons.model.Discretizer;
import ru.autosome.commons.model.Named;
import ru.autosome.commons.model.PseudocountCalculator;
import ru.autosome.commons.motifModel.Discretable;
import ru.autosome.commons.motifModel.ScoreDistribution;
import ru.autosome.commons.motifModel.types.DataModel;

public abstract class PrecalculateThresholds<ModelType extends Discretable<ModelType> & ScoreDistribution<BackgroundType>, BackgroundType extends GeneralizedBackgroundModel> {
    protected Discretizer discretizer;
    protected BackgroundType background;
    protected BoundaryType pvalue_boundary;
    protected Integer max_hash_size;
    protected DataModel data_model;
    protected double effective_count;
    protected PseudocountCalculator pseudocount;
    protected boolean silenceLog;
    protected File results_dir;
    protected double[] pvalues;
    protected boolean transpose;
    protected List<Named<ModelType>> motifList;

    protected abstract void initialize_default_background();

    protected abstract void extract_background(String var1);

    protected abstract PrecalculateThresholdList<ModelType, BackgroundType> calculator();

    protected abstract String DOC_background_option();

    protected abstract String DOC_run_string();

    protected abstract Named<ModelType> loadMotif(File var1);

    protected void initialize_defaults() {
        this.initialize_default_background();
        this.discretizer = new Discretizer(1000.0);
        this.pvalue_boundary = BoundaryType.LOWER;
        this.max_hash_size = 10000000;
        this.pvalues = PrecalculateThresholdList.PVALUE_LIST;
        this.data_model = DataModel.PWM;
        this.effective_count = 100.0;
        this.pseudocount = PseudocountCalculator.logPseudocount;
        this.silenceLog = false;
        this.transpose = false;
    }

    protected void setup_from_arglist(ArrayList<String> argv) {
        File[] collection_folder = this.extract_collection_files(argv);
        this.extract_output_folder_name(argv);
        while (argv.size() > 0) {
            this.extract_option(argv);
        }
        this.motifList = this.loadMotifs(collection_folder);
        this.create_results_folder();
    }

    protected File[] extract_collection_files(ArrayList<String> argv) {
        try {
            File collection_folder = new File(argv.remove(0));
            File[] files = collection_folder.listFiles();
            if (files == null) {
                System.err.println("Warning! No files in collection folder `" + collection_folder + "`!");
                return new File[0];
            }
            return files;
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Specify PWM-collection folder", e);
        }
    }

    protected void extract_output_folder_name(ArrayList<String> argv) {
        try {
            this.results_dir = new File(argv.remove(0));
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Specify output folder", e);
        }
    }

    protected void create_results_folder() {
        if (!this.results_dir.exists()) {
            this.results_dir.mkdir();
        }
    }

    protected void extract_option(ArrayList<String> argv) {
        String opt = argv.remove(0);
        if (opt.equals("-b") || opt.equals("--background")) {
            this.extract_background(argv.remove(0));
        } else if (opt.equals("--pvalues")) {
            this.pvalues = Progression.fromString(argv.remove(0)).values();
        } else if (opt.equals("--max-hash-size")) {
            this.max_hash_size = Integer.valueOf(argv.remove(0));
        } else if (opt.equals("-d") || opt.equals("--discretization")) {
            this.discretizer = Discretizer.fromString(argv.remove(0));
        } else if (opt.equals("--boundary")) {
            this.pvalue_boundary = BoundaryType.valueOf(argv.remove(0).toUpperCase());
        } else if (opt.equals("--pcm")) {
            this.data_model = DataModel.PCM;
        } else if (opt.equals("--ppm") || opt.equals("--pfm")) {
            this.data_model = DataModel.PPM;
        } else if (opt.equals("--effective-count")) {
            this.effective_count = Double.valueOf(argv.remove(0));
        } else if (opt.equals("--pseudocount")) {
            this.pseudocount = PseudocountCalculator.fromString(argv.remove(0));
        } else if (opt.equals("--silent")) {
            this.silenceLog = true;
        } else if (opt.equals("--transpose")) {
            this.transpose = true;
        } else if (this.failed_to_recognize_additional_options(opt, argv)) {
            throw new IllegalArgumentException("Unknown option '" + opt + "'");
        }
    }

    protected boolean failed_to_recognize_additional_options(String opt, List<String> argv) {
        return true;
    }

    List<Named<ModelType>> loadMotifs(File[] files) {
        ArrayList<Named<ModelType>> results = new ArrayList<Named<ModelType>>();
        for (File file : files) {
            results.add(this.loadMotif(file));
        }
        return results;
    }

    protected void calculate_thresholds_for_collection() throws HashOverflowException, IOException {
        for (Named<ModelType> motif : this.motifList) {
            if (!this.silenceLog) {
                System.err.println(motif.getName());
            }
            File result_filename = new File(this.results_dir, motif.getName() + ".thr");
            PvalueBsearchList bsearchList = this.calculator().bsearch_list_for_pwm((Discretable)motif.getObject());
            bsearchList.save_to_file(result_filename);
        }
    }

    public String documentString() {
        return "Command-line format:\n" + this.DOC_run_string() + " <collection folder> <output folder> [options]\n" + "\n" + "Options:\n" + "  [--discretization <discretization level>] or [-d]\n" + "  [--pcm] - treat the input files as Position Count Matrix. PCM-to-PWM transformation to be done internally.\n" + "  [--ppm] or [--pfm] - treat the input file as Position Frequency Matrix. PPM-to-PWM transformation to be done internally.\n" + "  [--effective-count <count>] - effective samples set size for PPM-to-PWM conversion (default: 100). \n" + "  [--boundary lower|upper] Lower boundary (default) means that the obtained P-value is less than or equal to the requested P-value\n" + "  [--background <background probabilities>] or [-b] " + this.DOC_background_option() + "\n" + "  [--pvalues <min pvalue>,<max pvalue>,<step>,<mul|add>] pvalue list parameters: boundaries, step, arithmetic(add)/geometric(mul) progression\n" + "  [--silent] - suppress logging\n" + "  [--transpose] - load motif from transposed matrix (nucleotides in lines).\n" + this.DOC_additional_options() + "\n" + "Examples:\n" + "  " + this.DOC_run_string() + " ./hocomoco/ ./hocomoco_thresholds/\n" + "  " + this.DOC_run_string() + " ./hocomoco/ ./hocomoco_thresholds/ -d 100 --pvalues 1e-6,0.1,1.5,mul\n";
    }

    protected String DOC_additional_options() {
        return "";
    }
}

