/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.ape.example;

import ru.autosome.ape.calculation.findPvalue.CanFindPvalue;
import ru.autosome.ape.calculation.findPvalue.FindPvalueAPE;
import ru.autosome.ape.model.exception.HashOverflowException;
import ru.autosome.commons.backgroundModel.mono.BackgroundModel;
import ru.autosome.commons.backgroundModel.mono.WordwiseBackground;
import ru.autosome.commons.importer.PWMImporter;
import ru.autosome.commons.model.Discretizer;
import ru.autosome.commons.motifModel.mono.PWM;

public class FindPvalue {
    static void print_result(CanFindPvalue.PvalueInfo info, BackgroundModel background, int pwmLength) {
        System.out.println("threshold: " + info.threshold + "\n" + "pvalue: " + info.pvalue + "\n" + "number of recognized words: " + info.numberOfRecognizedWords(background, pwmLength) + "\n------------\n");
    }

    public static void main(String[] args) {
        PWM pwm = (PWM)new PWMImporter().loadMotif("test_data/pwm/KLF4_f2.pwm");
        WordwiseBackground background = new WordwiseBackground();
        Discretizer discretizer = new Discretizer(10000.0);
        Integer max_hash_size = null;
        double threshold = 3.0;
        double[] thresholds = new double[]{3.0, 5.0, 7.0};
        FindPvalueAPE<PWM, WordwiseBackground> calculator = new FindPvalueAPE<PWM, WordwiseBackground>(pwm, background, discretizer, max_hash_size);
        CanFindPvalue.PvalueInfo info = null;
        try {
            info = calculator.pvalueByThreshold(threshold);
        }
        catch (HashOverflowException e) {
            e.printStackTrace();
        }
        FindPvalue.print_result(info, background, pwm.length());
        CanFindPvalue.PvalueInfo[] infos = new CanFindPvalue.PvalueInfo[]{};
        try {
            infos = calculator.pvaluesByThresholds(thresholds);
        }
        catch (HashOverflowException e) {
            e.printStackTrace();
        }
        for (CanFindPvalue.PvalueInfo info2 : infos) {
            FindPvalue.print_result(info2, background, pwm.length());
        }
    }
}

