/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.ape.example;

import ru.autosome.ape.calculation.findThreshold.CanFindThreshold;
import ru.autosome.ape.calculation.findThreshold.FindThresholdAPE;
import ru.autosome.ape.model.exception.HashOverflowException;
import ru.autosome.commons.backgroundModel.mono.BackgroundModel;
import ru.autosome.commons.backgroundModel.mono.WordwiseBackground;
import ru.autosome.commons.importer.PWMImporter;
import ru.autosome.commons.model.BoundaryType;
import ru.autosome.commons.model.Discretizer;
import ru.autosome.commons.motifModel.mono.PWM;

public class FindThreshold {
    static void print_result(CanFindThreshold.ThresholdInfo info, BackgroundModel background, int pwmLength) {
        System.out.println("expected pvalue: " + info.expected_pvalue + "\n" + "threshold: " + info.threshold + "\n" + "actual pvalue: " + info.real_pvalue + "\n" + "number of recognized words: " + info.numberOfRecognizedWords(background, pwmLength) + "\n------------\n");
    }

    public static void main(String[] args) {
        PWM pwm = (PWM)new PWMImporter().loadMotif("test_data/pwm/KLF4_f2.pwm");
        WordwiseBackground background = new WordwiseBackground();
        Discretizer discretizer = new Discretizer(10000.0);
        BoundaryType pvalue_boundary = BoundaryType.LOWER;
        Integer max_hash_size = null;
        double pvalue = 5.0E-4;
        double[] pvalues = new double[]{1.0E-4, 5.0E-4, 0.001};
        FindThresholdAPE<PWM, WordwiseBackground> calculator = new FindThresholdAPE<PWM, WordwiseBackground>(pwm, background, discretizer, max_hash_size);
        CanFindThreshold.ThresholdInfo info = null;
        try {
            info = calculator.thresholdByPvalue(pvalue, pvalue_boundary);
        }
        catch (HashOverflowException e) {
            e.printStackTrace();
        }
        FindThreshold.print_result(info, background, pwm.length());
        CanFindThreshold.ThresholdInfo[] infos = new CanFindThreshold.ThresholdInfo[]{};
        try {
            infos = calculator.thresholdsByPvalues(pvalues, pvalue_boundary);
        }
        catch (HashOverflowException e) {
            e.printStackTrace();
        }
        for (CanFindThreshold.ThresholdInfo info2 : infos) {
            FindThreshold.print_result(info2, background, pwm.length());
        }
    }
}

