/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.ape.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import ru.autosome.ape.calculation.findThreshold.CanFindThreshold;
import ru.autosome.commons.importer.InputExtensions;

public class PvalueBsearchList {
    private final List<ThresholdPvaluePair> list;

    public PvalueBsearchList() {
        this.list = new ArrayList<ThresholdPvaluePair>();
    }

    public PvalueBsearchList(List<ThresholdPvaluePair> infos) {
        Collections.sort(infos, ThresholdPvaluePair.thresholdComparator);
        this.list = this.without_consequent_duplicates(this.without_inf_nan_scores(this.without_zero_pvalue(infos)));
    }

    private List<ThresholdPvaluePair> without_consequent_duplicates(List<ThresholdPvaluePair> infos) {
        ArrayList<ThresholdPvaluePair> reduced_infos = new ArrayList<ThresholdPvaluePair>();
        if (infos.isEmpty()) {
            return reduced_infos;
        }
        reduced_infos.add(infos.get(0));
        for (int i = 1; i < infos.size(); ++i) {
            if (infos.get(i).equals(infos.get(i - 1))) continue;
            reduced_infos.add(infos.get(i));
        }
        return reduced_infos;
    }

    private List<ThresholdPvaluePair> without_zero_pvalue(List<ThresholdPvaluePair> infos) {
        ArrayList<ThresholdPvaluePair> reduced_infos = new ArrayList<ThresholdPvaluePair>();
        for (ThresholdPvaluePair info : infos) {
            if (info.pvalue == 0.0) continue;
            reduced_infos.add(info);
        }
        return reduced_infos;
    }

    private List<ThresholdPvaluePair> without_inf_nan_scores(List<ThresholdPvaluePair> infos) {
        ArrayList<ThresholdPvaluePair> reduced_infos = new ArrayList<ThresholdPvaluePair>();
        for (ThresholdPvaluePair info : infos) {
            Double score = info.threshold;
            if (score.isNaN() || score.isInfinite()) continue;
            reduced_infos.add(info);
        }
        return reduced_infos;
    }

    public double combine_pvalues(double pvalue_1, double pvalue_2) {
        return Math.sqrt(pvalue_1 * pvalue_2);
    }

    public double pvalue_by_threshold(double threshold) {
        int index = Collections.binarySearch(this.list, threshold, ThresholdPvaluePair.thresholdComparator);
        if (index >= 0) {
            return this.list.get((int)index).pvalue;
        }
        int insertion_point = -index - 1;
        if (insertion_point > 0 && insertion_point < this.list.size()) {
            return this.combine_pvalues(this.list.get((int)insertion_point).pvalue, this.list.get((int)(insertion_point - 1)).pvalue);
        }
        if (insertion_point == 0) {
            return this.list.get((int)0).pvalue;
        }
        return this.list.get((int)(this.list.size() - 1)).pvalue;
    }

    public ThresholdPvaluePair strongThresholdInfoByPvalue(double pvalue) {
        int index = Collections.binarySearch(this.list, pvalue, ThresholdPvaluePair.pvalueComparator);
        if (index >= 0) {
            return this.list.get(index);
        }
        int insertion_point = -index - 1;
        if (insertion_point > 0 && insertion_point < this.list.size()) {
            return this.list.get(insertion_point);
        }
        if (insertion_point == 0) {
            return this.list.get(0);
        }
        return this.list.get(this.list.size() - 1);
    }

    public ThresholdPvaluePair weakThresholdByPvalue(double pvalue) {
        int index = Collections.binarySearch(this.list, pvalue, ThresholdPvaluePair.pvalueComparator);
        if (index >= 0) {
            return this.list.get(index);
        }
        int insertion_point = -index - 1;
        if (insertion_point > 0 && insertion_point < this.list.size()) {
            return this.list.get(insertion_point - 1);
        }
        if (insertion_point == 0) {
            return this.list.get(0);
        }
        return this.list.get(this.list.size() - 1);
    }

    public void save_to_file(File file) throws IOException {
        FileWriter fw = new FileWriter(file);
        for (ThresholdPvaluePair info : this.list) {
            fw.write(info + "\n");
        }
        fw.close();
    }

    private static List<ThresholdPvaluePair> load_thresholds_list(List<String> lines) {
        ArrayList<ThresholdPvaluePair> result = new ArrayList<ThresholdPvaluePair>();
        for (String s : lines) {
            String[] line_tokens = s.replaceAll("\\s+", "\t").split("\t");
            if (line_tokens.length < 2) continue;
            double threshold = Double.valueOf(line_tokens[0]);
            double pvalue = Double.valueOf(line_tokens[1]);
            result.add(new ThresholdPvaluePair(threshold, pvalue));
        }
        return result;
    }

    public static List<ThresholdPvaluePair> load_thresholds_list(File file) throws FileNotFoundException {
        FileInputStream reader = new FileInputStream(file);
        List<String> lines = InputExtensions.readLinesFromInputStream(reader);
        return PvalueBsearchList.load_thresholds_list(lines);
    }

    public static PvalueBsearchList load_from_file(File file) throws FileNotFoundException {
        return new PvalueBsearchList(PvalueBsearchList.load_thresholds_list(file));
    }

    public static class ThresholdPvaluePair {
        public final double threshold;
        public final double pvalue;
        public static final Comparator thresholdComparator = new Comparator<Object>(){

            Double val(Object obj) {
                double value;
                if (obj instanceof ThresholdPvaluePair) {
                    value = ((ThresholdPvaluePair)obj).threshold;
                } else if (obj instanceof Double) {
                    value = (Double)obj;
                } else {
                    throw new ClassCastException("Incorrect type for comparison");
                }
                return value;
            }

            @Override
            public int compare(Object o1, Object o2) {
                return this.val(o1).compareTo(this.val(o2));
            }
        };
        public static final Comparator pvalueComparator = new Comparator<Object>(){

            Double val(Object obj) {
                double value;
                if (obj instanceof ThresholdPvaluePair) {
                    value = ((ThresholdPvaluePair)obj).pvalue;
                } else if (obj instanceof Double) {
                    value = (Double)obj;
                } else {
                    throw new ClassCastException("Incorrect type for comparison");
                }
                return value;
            }

            @Override
            public int compare(Object o1, Object o2) {
                return this.val(o1).compareTo(this.val(o2));
            }
        };

        public ThresholdPvaluePair(double threshold, double pvalue) {
            this.threshold = threshold;
            this.pvalue = pvalue;
        }

        public ThresholdPvaluePair(CanFindThreshold.ThresholdInfo info) {
            this.threshold = info.threshold;
            this.pvalue = info.real_pvalue;
        }

        public boolean equals(Object other) {
            return other instanceof ThresholdPvaluePair && this.threshold == ((ThresholdPvaluePair)other).threshold && this.pvalue == ((ThresholdPvaluePair)other).pvalue;
        }

        public int hashCode() {
            int hash = 1;
            hash = hash * 17 + Double.valueOf(this.threshold).hashCode();
            hash = hash * 31 + Double.valueOf(this.pvalue).hashCode();
            return hash;
        }

        public String toString() {
            return this.threshold + "\t" + this.pvalue;
        }
    }
}

