/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.commons.backgroundModel.di;

import ru.autosome.commons.backgroundModel.di.DiBackgroundModel;

public class DiWordwiseBackground
implements DiBackgroundModel {
    @Override
    public double probability(int index) {
        return 0.0625;
    }

    @Override
    public double conditionalCount(int previousLetter, int letter) {
        return 1.0;
    }

    @Override
    public double countAnyFirstLetter(int secondLetter) {
        return 1.0;
    }

    @Override
    public double countAnySecondLetter(int firstLetter) {
        return 1.0;
    }

    @Override
    public double volume() {
        return 4.0;
    }

    @Override
    public String toString() {
        return "wordwise";
    }

    @Override
    public boolean is_wordwise() {
        return true;
    }

    @Override
    public double mean_value(double[] values) {
        double sum = 0.0;
        for (int letter = 0; letter < 16; ++letter) {
            sum += values[letter];
        }
        return sum / 16.0;
    }

    @Override
    public double mean_square_value(double[] values) {
        double sum_square = 0.0;
        for (int letter = 0; letter < 16; ++letter) {
            sum_square += values[letter] * values[letter];
        }
        return sum_square / 16.0;
    }

    @Override
    public double variance(double[] values) {
        double mean = this.mean_value(values);
        return this.mean_square_value(values) - mean * mean;
    }

    @Override
    public double average_by_second_letter(double[] values, int firstLetterIndex) {
        double result = 0.0;
        for (int secondLetterIndex = 0; secondLetterIndex < 4; ++secondLetterIndex) {
            int letter = 4 * firstLetterIndex + secondLetterIndex;
            result += values[letter];
        }
        return result / 4.0;
    }

    @Override
    public double average_by_first_letter(double[] values, int secondLetterIndex) {
        double result = 0.0;
        for (int firstLetterIndex = 0; firstLetterIndex < 4; ++firstLetterIndex) {
            int letter = 4 * firstLetterIndex + secondLetterIndex;
            result += values[letter];
        }
        return result / 4.0;
    }
}

