/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.commons.backgroundModel.mono;

import ru.autosome.commons.backgroundModel.mono.BackgroundModel;

public class WordwiseBackground
implements BackgroundModel {
    @Override
    public double probability(int index) {
        return 0.25;
    }

    @Override
    public double count(int index) {
        return 1.0;
    }

    @Override
    public double volume() {
        return 4.0;
    }

    @Override
    public String toString() {
        return "wordwise";
    }

    @Override
    public boolean is_wordwise() {
        return true;
    }

    @Override
    public double mean_value(double[] values) {
        double sum = 0.0;
        for (int letter = 0; letter < 4; ++letter) {
            sum += values[letter];
        }
        return sum / 4.0;
    }

    @Override
    public double mean_square_value(double[] values) {
        double sum_square = 0.0;
        for (int letter = 0; letter < 4; ++letter) {
            sum_square += values[letter] * values[letter];
        }
        return sum_square / 4.0;
    }

    @Override
    public double variance(double[] values) {
        double mean = this.mean_value(values);
        return this.mean_square_value(values) - mean * mean;
    }

    public boolean equals(Object other) {
        return other instanceof BackgroundModel && ((BackgroundModel)other).is_wordwise();
    }
}

