/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.commons.importer;

import java.util.ArrayList;
import java.util.List;
import ru.autosome.commons.importer.InputExtensions;
import ru.autosome.commons.importer.ParsingResult;

public class NormalMatrixParser {
    public final int alphabet_size;

    public NormalMatrixParser(int alphabet_size) {
        this.alphabet_size = alphabet_size;
    }

    String getName(List<String> strings) {
        String header = strings.get(0).trim();
        if (header.charAt(0) == '>') {
            return header.substring(1).trim();
        }
        if (!InputExtensions.startWithDouble(header)) {
            return header;
        }
        return null;
    }

    List<String> withoutHeader(List<String> strings) {
        String header = strings.get(0).trim();
        if (header.charAt(0) == '>' || !InputExtensions.startWithDouble(header)) {
            return strings.subList(1, strings.size());
        }
        return strings;
    }

    public ParsingResult parse(List<String> strings) {
        String name = this.getName(strings);
        strings = InputExtensions.beforeEmptyLine(this.withoutHeader(strings));
        ArrayList<double[]> matrix = new ArrayList<double[]>();
        for (String positionString : strings) {
            String[] weights = positionString.split("\\s+");
            if (weights.length != this.alphabet_size) {
                throw new RuntimeException("Incorrect number of weights per line in the matrix input file.");
            }
            double[] positionParsed = new double[this.alphabet_size];
            for (int letterIndex = 0; letterIndex < this.alphabet_size; ++letterIndex) {
                positionParsed[letterIndex] = Double.parseDouble(weights[letterIndex]);
            }
            matrix.add(positionParsed);
        }
        return new ParsingResult(matrix, name);
    }
}

