/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.commons.model;

import java.util.HashMap;
import java.util.Map;

public class Alphabet {
    protected final int codeLength;
    protected final int alphabetSize;
    protected final String[] letters;
    protected final Map<String, Byte> letterIndices;
    protected final Map<Byte, Byte> reverseComplements;
    public static final Alphabet monoACGTN = Alphabet.byLetters(1, "ACGTN", "TGCAN");
    public static final Alphabet diACGTN = Alphabet.byLetters(2, "ACGTN", "TGCAN");

    private Alphabet(int codeLength, int alphabetSize, String[] letters, Map<String, Byte> letterIndices, Map<Byte, Byte> reverseComplements) {
        if (Math.pow(alphabetSize, codeLength) != (double)letters.length) {
            throw new IllegalArgumentException("letters array size should be equal to alphabetSize ** codeLength");
        }
        if (letterIndices.size() != letters.length || letterIndices.size() != reverseComplements.size()) {
            throw new IllegalArgumentException("letters and complements sizes are not compatible");
        }
        for (String string : letterIndices.keySet()) {
            if (string.length() != codeLength) {
                throw new IllegalArgumentException("Key size should be equal to code size");
            }
            if (string == letters[letterIndices.get(string)]) continue;
            throw new IllegalArgumentException("Letters should be compatible with letter indices");
        }
        for (Map.Entry entry : reverseComplements.entrySet()) {
            if (entry.getKey() == reverseComplements.get(entry.getValue())) continue;
            throw new IllegalArgumentException("Reverse of reverse should be equal to itself");
        }
        this.codeLength = codeLength;
        this.alphabetSize = alphabetSize;
        this.letters = letters;
        this.letterIndices = letterIndices;
        this.reverseComplements = reverseComplements;
    }

    public byte[] convertString(String seq) {
        if (seq.length() < this.codeLength) {
            throw new IllegalArgumentException("Sequence '" + seq + "' is not compatible with alphabet of length " + this.codeLength);
        }
        String normalizedSeq = seq.toUpperCase();
        byte[] result = new byte[normalizedSeq.length() + 1 - this.codeLength];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.letterIndices.get(normalizedSeq.substring(i, i + this.codeLength));
        }
        return result;
    }

    public byte[] reverseComplement(byte[] seq) {
        int len = seq.length;
        byte[] result = new byte[len];
        for (int i = 0; i < len; ++i) {
            result[i] = this.reverseComplements.get(seq[len - 1 - i]);
        }
        return result;
    }

    private static String stringByIndex(int ind, String letters, int codeLength) {
        StringBuilder str = new StringBuilder(codeLength);
        int indRemainder = ind;
        for (int letterIndex = 0; letterIndex < codeLength; ++letterIndex) {
            int letterPosition = indRemainder % letters.length();
            str.append(letters.charAt(letterPosition));
            indRemainder /= letters.length();
        }
        return str.reverse().toString();
    }

    public static Alphabet byLetters(int codeLength, String letters, String complementLetters) {
        if (letters.length() != complementLetters.length()) {
            throw new RuntimeException("Error in program: number of letters and complement letters in alphabet definition differs");
        }
        HashMap<String, Byte> letterIndices = new HashMap<String, Byte>();
        HashMap<Byte, Byte> complements = new HashMap<Byte, Byte>();
        String[] separateLetters = new String[(int)Math.pow(letters.length(), codeLength)];
        letters = letters.toUpperCase();
        complementLetters = complementLetters.toUpperCase();
        byte ind = 0;
        while ((double)ind < Math.pow(letters.length(), codeLength)) {
            String directSeq = Alphabet.stringByIndex(ind, letters, codeLength);
            letterIndices.put(directSeq, ind);
            separateLetters[ind] = directSeq;
            ind = (byte)(ind + 1);
        }
        ind = 0;
        while ((double)ind < Math.pow(letters.length(), codeLength)) {
            String complementSeq = Alphabet.stringByIndex(ind, complementLetters, codeLength);
            String revcompSeq = new StringBuilder(complementSeq).reverse().toString();
            complements.put(ind, (Byte)letterIndices.get(revcompSeq));
            ind = (byte)(ind + 1);
        }
        return new Alphabet(codeLength, letters.length(), separateLetters, letterIndices, complements);
    }

    public int getCodeLength() {
        return this.codeLength;
    }

    public String decodeString(byte[] seq) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < seq.length - 1; ++i) {
            str.append(this.letters[seq[i]].charAt(0));
        }
        str.append(this.letters[seq[seq.length - 1]]);
        return str.toString();
    }

    public boolean isConsistent(byte[] seq) {
        for (int i = 1; i < seq.length; ++i) {
            if (seq[i - 1] % (int)Math.pow(this.alphabetSize, this.codeLength - 1) == seq[i] / this.codeLength) continue;
            return false;
        }
        return true;
    }
}

