/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.commons.model;

public class Discretizer {
    public final Double discretization;

    public Discretizer(Double discretization) {
        this.discretization = discretization;
    }

    public static Discretizer fromString(String s) {
        return new Discretizer(Double.valueOf(s));
    }

    public double upscale(double value) {
        if (this.discretization == null) {
            return value;
        }
        return value * this.discretization;
    }

    public double[] upscale(double[] values) {
        double[] result = new double[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = this.upscale(values[i]);
        }
        return result;
    }

    public double downscale(double value) {
        if (this.discretization == null) {
            return value;
        }
        return value / this.discretization;
    }

    public double discrete(double value) {
        if (this.discretization == null) {
            return value;
        }
        return Math.ceil(value * this.discretization);
    }

    public String toString() {
        return this.discretization.toString();
    }
}

