/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.commons.model;

import ru.autosome.commons.model.Orientation;
import ru.autosome.commons.motifModel.HasLength;
import ru.autosome.commons.motifModel.ScoringModel;
import ru.autosome.perfectosape.calculation.ScanSequence;

public class PositionInterval {
    public final int left;
    public final int right;

    PositionInterval(int left, int right) {
        if (left >= right) {
            throw new IllegalArgumentException("Left should be less than right");
        }
        this.left = left;
        this.right = right;
    }

    public <SequenceType extends HasLength> ScanSequence.BestPositionWithScore findBestPosition(SequenceType sequence, ScoringModel<SequenceType> scoringModel) {
        ScanSequence.BestPositionWithScore bestPos = new ScanSequence.BestPositionWithScore();
        for (int pos = Math.max(this.left, 0); pos <= Math.min(this.right, sequence.length() - scoringModel.length()); ++pos) {
            bestPos.updateBestScore(pos, Orientation.direct, scoringModel.score(sequence, Orientation.direct, pos));
            bestPos.updateBestScore(pos, Orientation.revcomp, scoringModel.score(sequence, Orientation.revcomp, pos));
        }
        return bestPos;
    }

    public String toString() {
        return "[" + this.left + ";" + this.right + "]";
    }

    public PositionInterval expand(int expandRegionLength) {
        return new PositionInterval(this.left - expandRegionLength, this.right + expandRegionLength);
    }
}

