/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.commons.scoringModel;

import ru.autosome.commons.backgroundModel.di.DiBackgroundModel;
import ru.autosome.commons.backgroundModel.di.DiWordwiseBackground;
import ru.autosome.commons.model.Orientation;
import ru.autosome.commons.motifModel.Encodable;
import ru.autosome.commons.motifModel.ScoringModel;
import ru.autosome.commons.motifModel.di.DiPWM;
import ru.autosome.perfectosape.model.Sequence;
import ru.autosome.perfectosape.model.SequenceWithSNP;
import ru.autosome.perfectosape.model.encoded.di.SequenceDiEncoded;
import ru.autosome.perfectosape.model.encoded.di.SequenceWithSNPDiEncoded;

public class DiPWMOnBackground
implements ScoringModel<SequenceDiEncoded>,
Encodable<SequenceDiEncoded, SequenceWithSNPDiEncoded> {
    private final DiPWM dipwm;
    private final DiBackgroundModel dibackground;
    private final double[][] matrixIUPAC;

    public DiPWMOnBackground(DiPWM dipwm, DiBackgroundModel dibackground) {
        this.dipwm = dipwm;
        this.dibackground = dibackground;
        this.matrixIUPAC = this.calculateMatrixIUPAC();
    }

    public DiPWMOnBackground(DiPWM dipwm) {
        this.dipwm = dipwm;
        this.dibackground = new DiWordwiseBackground();
        this.matrixIUPAC = this.calculateMatrixIUPAC();
    }

    private double[][] calculateMatrixIUPAC() {
        double[][] result = new double[this.dipwm.getMatrix().length][];
        for (int posIndex = 0; posIndex < this.dipwm.getMatrix().length; ++posIndex) {
            result[posIndex] = new double[25];
            for (int firstLetterIndex = 0; firstLetterIndex < 4; ++firstLetterIndex) {
                for (int secondLetterIndex = 0; secondLetterIndex < 4; ++secondLetterIndex) {
                    result[posIndex][5 * firstLetterIndex + secondLetterIndex] = this.dipwm.getMatrix()[posIndex][4 * firstLetterIndex + secondLetterIndex];
                }
                result[posIndex][5 * firstLetterIndex + 4] = this.dibackground.average_by_second_letter(this.dipwm.getMatrix()[posIndex], firstLetterIndex);
            }
            for (int secondLetterIndex = 0; secondLetterIndex < 4; ++secondLetterIndex) {
                result[posIndex][20 + secondLetterIndex] = this.dibackground.average_by_first_letter(this.dipwm.getMatrix()[posIndex], secondLetterIndex);
            }
            result[posIndex][24] = this.dibackground.mean_value(this.dipwm.getMatrix()[posIndex]);
        }
        return result;
    }

    @Override
    public int length() {
        return this.dipwm.length();
    }

    @Override
    public double score(SequenceDiEncoded word) {
        return this.score(word, Orientation.direct, 0);
    }

    @Override
    public double score(SequenceDiEncoded word, Orientation orientation, int position) {
        int startPos;
        byte[] seq;
        if (orientation == Orientation.direct) {
            seq = word.directSequence;
            startPos = position;
        } else {
            seq = word.revcompSequence;
            startPos = word.length() - (position + this.length());
        }
        double sum = 0.0;
        for (int pos_index = 0; pos_index < this.matrixIUPAC.length; ++pos_index) {
            byte letter = seq[startPos + pos_index];
            sum += this.matrixIUPAC[pos_index][letter];
        }
        return sum;
    }

    @Override
    public double score_mean() {
        double result = 0.0;
        for (double[] pos : this.dipwm.getMatrix()) {
            result += this.dibackground.mean_value(pos);
        }
        return result;
    }

    @Override
    public double score_variance() {
        double variance = 0.0;
        for (double[] pos : this.dipwm.getMatrix()) {
            variance += this.dibackground.variance(pos);
        }
        return variance;
    }

    @Override
    public SequenceDiEncoded encodeSequence(Sequence sequence) {
        return sequence.diEncode();
    }

    @Override
    public SequenceWithSNPDiEncoded encodeSequenceWithSNP(SequenceWithSNP sequenceWithSNP) {
        return sequenceWithSNP.diEncode();
    }
}

