/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.macroape.calculation.generalized;

import ru.autosome.ape.calculation.findPvalue.CanFindPvalue;
import ru.autosome.ape.calculation.findPvalue.FindPvalueAPE;
import ru.autosome.ape.calculation.findThreshold.FindThresholdAPE;
import ru.autosome.ape.model.exception.HashOverflowException;
import ru.autosome.commons.backgroundModel.GeneralizedBackgroundModel;
import ru.autosome.commons.model.Discretizer;
import ru.autosome.commons.model.Position;
import ru.autosome.commons.motifModel.Alignable;
import ru.autosome.commons.motifModel.Discretable;
import ru.autosome.macroape.calculation.generalized.CompareModelsCountsGiven;

public abstract class CompareModels<ModelType extends Alignable<ModelType> & Discretable<ModelType>, BackgroundType extends GeneralizedBackgroundModel> {
    public final ModelType firstPWM;
    public final ModelType secondPWM;
    public final BackgroundType firstBackground;
    public final BackgroundType secondBackground;
    public final CanFindPvalue firstPvalueCalculator;
    public final CanFindPvalue secondPvalueCalculator;
    public final Discretizer discretizer;
    public final Integer maxPairHashSize;

    public CompareModels(ModelType firstPWM, ModelType secondPWM, BackgroundType firstBackground, BackgroundType secondBackground, CanFindPvalue firstPvalueCalculator, CanFindPvalue secondPvalueCalculator, Discretizer discretizer, Integer maxPairHashSize) {
        this.firstPWM = firstPWM;
        this.secondPWM = secondPWM;
        this.firstBackground = firstBackground;
        this.secondBackground = secondBackground;
        this.firstPvalueCalculator = firstPvalueCalculator;
        this.secondPvalueCalculator = secondPvalueCalculator;
        this.discretizer = discretizer;
        this.maxPairHashSize = maxPairHashSize;
    }

    public CompareModels(ModelType firstPWM, ModelType secondPWM, BackgroundType firstBackground, BackgroundType secondBackground, Discretizer discretizer, Integer maxPairHashSize, Integer maxHashSize) {
        this.firstPWM = firstPWM;
        this.secondPWM = secondPWM;
        this.firstBackground = firstBackground;
        this.secondBackground = secondBackground;
        this.firstPvalueCalculator = new FindPvalueAPE<ModelType, BackgroundType>(firstPWM, firstBackground, discretizer, maxHashSize);
        this.secondPvalueCalculator = new FindPvalueAPE<ModelType, BackgroundType>(secondPWM, secondBackground, discretizer, maxHashSize);
        this.discretizer = discretizer;
        this.maxPairHashSize = maxPairHashSize;
    }

    protected abstract CompareModelsCountsGiven<ModelType, BackgroundType> calculatorWithCountsGiven();

    double firstCount(double threshold_first) throws HashOverflowException {
        return this.firstPvalueCalculator.pvalueByThreshold(threshold_first).numberOfRecognizedWords((GeneralizedBackgroundModel)this.firstBackground, this.firstPWM.length());
    }

    double secondCount(double threshold_second) throws HashOverflowException {
        return this.secondPvalueCalculator.pvalueByThreshold(threshold_second).numberOfRecognizedWords((GeneralizedBackgroundModel)this.secondBackground, this.secondPWM.length());
    }

    public CompareModelsCountsGiven.SimilarityInfo<ModelType> jaccard(double threshold_first, double threshold_second) throws HashOverflowException {
        return this.calculatorWithCountsGiven().jaccard(threshold_first, threshold_second, this.firstCount(threshold_first), this.secondCount(threshold_second));
    }

    public CompareModelsCountsGiven.SimilarityInfo<ModelType> jaccardAtPosition(double threshold_first, double threshold_second, Position position) throws HashOverflowException {
        return this.calculatorWithCountsGiven().jaccardAtPosition(threshold_first, threshold_second, this.firstCount(threshold_first), this.secondCount(threshold_second), position);
    }

    public CompareModelsCountsGiven.SimilarityInfo jaccard_by_pvalue(double pvalue) throws HashOverflowException {
        FindThresholdAPE<Discretable, BackgroundType> canFindThresholdFirst = new FindThresholdAPE<Discretable, BackgroundType>((Discretable)this.firstPWM, this.firstBackground, this.discretizer, null);
        FindThresholdAPE<Discretable, BackgroundType> canFindThresholdSecond = new FindThresholdAPE<Discretable, BackgroundType>((Discretable)this.secondPWM, this.secondBackground, this.discretizer, null);
        double threshold_first = canFindThresholdFirst.strongThresholdByPvalue((double)pvalue).threshold;
        double threshold_second = canFindThresholdSecond.strongThresholdByPvalue((double)pvalue).threshold;
        return this.jaccard(threshold_first, threshold_second);
    }

    public CompareModelsCountsGiven.SimilarityInfo jaccard_by_weak_pvalue(double pvalue) throws HashOverflowException {
        FindThresholdAPE<Discretable, BackgroundType> canFindThresholdFirst = new FindThresholdAPE<Discretable, BackgroundType>((Discretable)this.firstPWM, this.firstBackground, this.discretizer, null);
        FindThresholdAPE<Discretable, BackgroundType> canFindThresholdSecond = new FindThresholdAPE<Discretable, BackgroundType>((Discretable)this.secondPWM, this.secondBackground, this.discretizer, null);
        double threshold_first = canFindThresholdFirst.weakThresholdByPvalue((double)pvalue).threshold;
        double threshold_second = canFindThresholdSecond.weakThresholdByPvalue((double)pvalue).threshold;
        return this.jaccard(threshold_first, threshold_second);
    }
}

