/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.macroape.cli.generalized;

import java.util.ArrayList;
import java.util.List;
import ru.autosome.ape.calculation.findThreshold.FindThresholdAPE;
import ru.autosome.ape.model.exception.HashOverflowException;
import ru.autosome.commons.backgroundModel.GeneralizedBackgroundModel;
import ru.autosome.commons.cli.OutputInformation;
import ru.autosome.commons.model.BoundaryType;
import ru.autosome.commons.model.Discretizer;
import ru.autosome.commons.model.Position;
import ru.autosome.commons.model.PseudocountCalculator;
import ru.autosome.commons.motifModel.Discretable;
import ru.autosome.commons.motifModel.ScoreDistribution;
import ru.autosome.commons.motifModel.types.DataModel;
import ru.autosome.macroape.calculation.generalized.CompareModels;
import ru.autosome.macroape.calculation.generalized.CompareModelsCountsGiven;

public abstract class EvalSimilarity<ModelType extends Discretable<ModelType> & ScoreDistribution<BackgroundType>, BackgroundType extends GeneralizedBackgroundModel> {
    protected BackgroundType firstBackground;
    protected BackgroundType secondBackground;
    protected Discretizer discretizer;
    protected double pvalue;
    protected BoundaryType pvalueBoundary;
    protected String firstPMFilename;
    protected String secondPMFilename;
    protected DataModel dataModelFirst;
    protected DataModel dataModelSecond;
    protected Integer maxHashSize;
    protected Integer maxPairHashSize;
    protected PseudocountCalculator pseudocountFirst;
    protected PseudocountCalculator pseudocountSecond;
    protected Double effectiveCountFirst;
    protected Double effectiveCountSecond;
    protected Double predefinedFirstThreshold;
    protected Double predefinedSecondThreshold;
    protected ModelType firstPWM;
    protected ModelType secondPWM;
    protected Double cacheFirstThreshold;
    protected Double cacheSecondThreshold;
    protected Position alignment;
    protected boolean transposeFirst;
    protected boolean transposeSecond;

    protected abstract String DOC_background_option();

    protected abstract String DOC_run_string();

    protected String DOC_additional_options() {
        return "";
    }

    protected String documentString() {
        return "Command-line format:\n" + this.DOC_run_string() + " <1st matrix pat-file> <2nd matrix pat-file> [options]\n" + "\n" + "Options:\n" + "  [--pvalue <P-value>] or [-p]\n" + "  [--discretization <discretization level>] or [-d]\n" + "  [--[first-|second-]pcm] - treat the input file as Position Count Matrix. PCM-to-PWM transformation to be done internally.\n" + "  [--[first-|second-]ppm] or [--pfm] - treat the input file as Position Frequency Matrix. PPM-to-PWM transformation to be done internally.\n" + "  [--[first-|second-]effective-count <count>] - effective samples set size for PPM-to-PWM conversion (default: 100). \n" + "  [--boundary lower|upper] Upper boundary (default) means that the obtained P-value is greater than or equal to the requested P-value\n" + "  [--background <background probabilities>] or [-b] " + this.DOC_background_option() + "\n" + "  [--first-threshold <threshold for the first matrix>]\n" + "  [--second-threshold <threshold for the second matrix>]\n" + "  [--position <shift>,<direct|revcomp>] - specify relative alignment to test. By default every alignment tested (example: --position -3,revcomp). Comma not allowed.\n" + "  [--[first-|second-]transpose] - load motif from transposed matrix (nucleotides in lines).\n" + this.DOC_additional_options() + "\n" + "Examples:\n" + "  " + this.DOC_run_string() + " motifs/KLF4_f2.pat motifs/SP1_f1.pat -p 0.0005 -d 100 -b 0.3,0.2,0.2,0.3\n";
    }

    protected abstract BackgroundType extract_background(String var1);

    protected abstract ModelType loadFirstPWM(String var1);

    protected abstract ModelType loadSecondPWM(String var1);

    protected abstract CompareModels<ModelType, BackgroundType> calculator();

    protected void setup_from_arglist(ArrayList<String> argv) {
        this.extract_first_pm_filename(argv);
        this.extract_second_pm_filename(argv);
        while (argv.size() > 0) {
            this.extract_option(argv);
        }
        this.firstPWM = this.loadFirstPWM(this.firstPMFilename);
        this.secondPWM = this.loadSecondPWM(this.secondPMFilename);
    }

    protected void extract_first_pm_filename(ArrayList<String> argv) {
        if (argv.isEmpty()) {
            throw new IllegalArgumentException("No input. You should specify input file");
        }
        this.firstPMFilename = argv.remove(0);
    }

    protected void extract_second_pm_filename(ArrayList<String> argv) {
        if (argv.isEmpty()) {
            throw new IllegalArgumentException("No input. You should specify input file");
        }
        this.secondPMFilename = argv.remove(0);
    }

    protected boolean failed_to_recognize_additional_options(String opt, List<String> argv) {
        return true;
    }

    protected abstract void initialize_default_background();

    protected void initialize_defaults() {
        this.initialize_default_background();
        this.dataModelFirst = DataModel.PWM;
        this.dataModelSecond = DataModel.PWM;
        this.effectiveCountFirst = 100.0;
        this.effectiveCountSecond = 100.0;
        this.pseudocountFirst = PseudocountCalculator.logPseudocount;
        this.pseudocountSecond = PseudocountCalculator.logPseudocount;
        this.pvalue = 5.0E-4;
        this.discretizer = new Discretizer(10.0);
        this.transposeFirst = false;
        this.transposeSecond = false;
        this.maxHashSize = 10000000;
        this.maxPairHashSize = 10000;
        this.pvalueBoundary = BoundaryType.UPPER;
        this.alignment = null;
    }

    protected void extract_option(ArrayList<String> argv) {
        String opt = argv.remove(0);
        if (opt.equals("-b") || opt.equals("--background")) {
            BackgroundType background = this.extract_background(argv.remove(0));
            this.firstBackground = background;
            this.secondBackground = background;
        } else if (opt.equals("-p") || opt.equals("--pvalue")) {
            this.pvalue = Double.valueOf(argv.remove(0));
        } else if (opt.equals("--first-background")) {
            this.firstBackground = this.extract_background(argv.remove(0));
        } else if (opt.equals("--second-background")) {
            this.secondBackground = this.extract_background(argv.remove(0));
        } else if (opt.equals("--max-hash-size")) {
            this.maxHashSize = Integer.valueOf(argv.remove(0));
        } else if (opt.equals("--max-2d-hash-size")) {
            this.maxPairHashSize = Integer.valueOf(argv.remove(0));
        } else if (opt.equals("-d") || opt.equals("--discretization")) {
            this.discretizer = Discretizer.fromString(argv.remove(0));
        } else if (opt.equals("--boundary")) {
            this.pvalueBoundary = BoundaryType.valueOf(argv.remove(0).toUpperCase());
        } else if (opt.equals("--pcm")) {
            this.dataModelFirst = DataModel.PCM;
            this.dataModelSecond = DataModel.PCM;
        } else if (opt.equals("--first-pcm")) {
            this.dataModelFirst = DataModel.PCM;
        } else if (opt.equals("--second-pcm")) {
            this.dataModelSecond = DataModel.PCM;
        } else if (opt.equals("--ppm") || opt.equals("--pfm")) {
            this.dataModelFirst = DataModel.PPM;
            this.dataModelSecond = DataModel.PPM;
        } else if (opt.equals("--first-ppm") || opt.equals("--first-pfm")) {
            this.dataModelFirst = DataModel.PPM;
        } else if (opt.equals("--second-ppm") || opt.equals("--second-pfm")) {
            this.dataModelSecond = DataModel.PPM;
        } else if (opt.equals("--effective-count")) {
            Double effectiveCount;
            this.effectiveCountFirst = effectiveCount = Double.valueOf(argv.remove(0));
            this.effectiveCountSecond = effectiveCount;
        } else if (opt.equals("--first-effective-count")) {
            this.effectiveCountFirst = Double.valueOf(argv.remove(0));
        } else if (opt.equals("--second-effective-count")) {
            this.effectiveCountSecond = Double.valueOf(argv.remove(0));
        } else if (opt.equals("--pseudocount")) {
            PseudocountCalculator pseudocount;
            this.pseudocountFirst = pseudocount = PseudocountCalculator.fromString(argv.remove(0));
            this.pseudocountSecond = pseudocount;
        } else if (opt.equals("--first-pseudocount")) {
            this.pseudocountFirst = PseudocountCalculator.fromString(argv.remove(0));
        } else if (opt.equals("--second-pseudocount")) {
            this.pseudocountSecond = PseudocountCalculator.fromString(argv.remove(0));
        } else if (opt.equals("--first-threshold")) {
            this.predefinedFirstThreshold = Double.valueOf(argv.remove(0));
        } else if (opt.equals("--second-threshold")) {
            this.predefinedSecondThreshold = Double.valueOf(argv.remove(0));
        } else if (opt.equals("--position")) {
            String pos_string = argv.remove(0);
            String[] pos_tokens = pos_string.split(",");
            Integer shift = Integer.valueOf(pos_tokens[0]);
            String orientation = pos_tokens[1];
            this.alignment = new Position((int)shift, orientation);
        } else if (opt.equals("--transpose")) {
            this.transposeFirst = true;
            this.transposeSecond = true;
        } else if (opt.equals("--first-transpose")) {
            this.transposeFirst = true;
        } else if (opt.equals("--second-transpose")) {
            this.transposeSecond = true;
        } else if (this.failed_to_recognize_additional_options(opt, argv)) {
            throw new IllegalArgumentException("Unknown option '" + opt + "'");
        }
    }

    OutputInformation report_table_layout() {
        OutputInformation infos = new OutputInformation();
        infos.add_parameter("V", "discretization", this.discretizer);
        if (this.predefinedFirstThreshold == null || this.predefinedSecondThreshold == null) {
            infos.add_parameter("P", "requested P-value", this.pvalue);
        }
        if (this.predefinedFirstThreshold != null) {
            infos.add_parameter("T1", "threshold for the 1st matrix", this.predefinedFirstThreshold);
        }
        if (this.predefinedSecondThreshold != null) {
            infos.add_parameter("T2", "threshold for the 2nd matrix", this.predefinedSecondThreshold);
        }
        infos.add_parameter("PB", "P-value boundary", (Object)this.pvalueBoundary);
        if (this.firstBackground.equals(this.secondBackground)) {
            infos.background_parameter("B", "background", (GeneralizedBackgroundModel)this.firstBackground);
        } else {
            infos.background_parameter("B1", "background for the 1st model", (GeneralizedBackgroundModel)this.firstBackground);
            infos.background_parameter("B2", "background for the 2nd model", (GeneralizedBackgroundModel)this.secondBackground);
        }
        return infos;
    }

    protected OutputInformation report_table(CompareModelsCountsGiven.SimilarityInfo info) throws HashOverflowException {
        OutputInformation infos = this.report_table_layout();
        infos.add_resulting_value("S", "similarity", info.similarity());
        infos.add_resulting_value("D", "distance (1-similarity)", info.distance());
        infos.add_resulting_value("L", "length of the alignment", info.alignment.length());
        infos.add_resulting_value("SH", "shift of the 2nd PWM relative to the 1st", info.alignment.shift());
        infos.add_resulting_value("OR", "orientation of the 2nd PWM relative to the 1st", (Object)info.alignment.orientation());
        infos.add_resulting_value("A1", "aligned 1st matrix", info.alignment.first_model_alignment());
        infos.add_resulting_value("A2", "aligned 2nd matrix", info.alignment.second_model_alignment());
        infos.add_resulting_value("W", "number of words recognized by both models (model = PWM + threshold)", info.recognizedByBoth);
        infos.add_resulting_value("W1", "number of words and recognized by the first model", info.recognizedByFirst);
        infos.add_resulting_value("P1", "P-value for the 1st matrix", info.realPvalueFirst((GeneralizedBackgroundModel)this.firstBackground));
        if (this.predefinedFirstThreshold == null) {
            infos.add_resulting_value("T1", "threshold for the 1st matrix", this.thresholdFirst());
        }
        infos.add_resulting_value("W2", "number of words recognized by the 2nd model", info.recognizedBySecond);
        infos.add_resulting_value("P2", "P-value for the 2nd matrix", info.realPvalueSecond((GeneralizedBackgroundModel)this.secondBackground));
        if (this.predefinedSecondThreshold == null) {
            infos.add_resulting_value("T2", "threshold for the 2nd matrix", this.thresholdSecond());
        }
        return infos;
    }

    protected CompareModelsCountsGiven.SimilarityInfo<ModelType> results() throws HashOverflowException {
        if (this.alignment == null) {
            return this.calculator().jaccard(this.thresholdFirst(), this.thresholdSecond());
        }
        return this.calculator().jaccardAtPosition(this.thresholdFirst(), this.thresholdSecond(), this.alignment);
    }

    protected OutputInformation report_table() throws Exception {
        return this.report_table(this.results());
    }

    protected double thresholdFirst() throws HashOverflowException {
        if (this.cacheFirstThreshold == null) {
            if (this.predefinedFirstThreshold != null) {
                this.cacheFirstThreshold = this.predefinedFirstThreshold;
            } else {
                FindThresholdAPE<ModelType, BackgroundType> pvalue_calculator = new FindThresholdAPE<ModelType, BackgroundType>(this.firstPWM, this.firstBackground, this.discretizer, this.maxHashSize);
                this.cacheFirstThreshold = pvalue_calculator.thresholdByPvalue((double)this.pvalue, (BoundaryType)this.pvalueBoundary).threshold;
            }
        }
        return this.cacheFirstThreshold;
    }

    protected double thresholdSecond() throws HashOverflowException {
        if (this.cacheSecondThreshold == null) {
            if (this.predefinedSecondThreshold != null) {
                this.cacheSecondThreshold = this.predefinedSecondThreshold;
            } else {
                FindThresholdAPE<ModelType, BackgroundType> pvalue_calculator = new FindThresholdAPE<ModelType, BackgroundType>(this.secondPWM, this.secondBackground, this.discretizer, this.maxHashSize);
                this.cacheSecondThreshold = pvalue_calculator.thresholdByPvalue((double)this.pvalue, (BoundaryType)this.pvalueBoundary).threshold;
            }
        }
        return this.cacheSecondThreshold;
    }
}

