/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.macroape.cli.generalized;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import ru.autosome.ape.calculation.findPvalue.CanFindPvalue;
import ru.autosome.ape.calculation.findPvalue.FindPvalueAPE;
import ru.autosome.ape.calculation.findPvalue.FindPvalueBsearchBuilder;
import ru.autosome.ape.calculation.findThreshold.CanFindThreshold;
import ru.autosome.ape.calculation.findThreshold.FindThresholdAPE;
import ru.autosome.ape.calculation.findThreshold.FindThresholdBsearchBuilder;
import ru.autosome.commons.backgroundModel.GeneralizedBackgroundModel;
import ru.autosome.commons.cli.OutputInformation;
import ru.autosome.commons.cli.ResultInfo;
import ru.autosome.commons.importer.InputExtensions;
import ru.autosome.commons.model.BoundaryType;
import ru.autosome.commons.model.Discretizer;
import ru.autosome.commons.model.Named;
import ru.autosome.commons.model.PseudocountCalculator;
import ru.autosome.commons.motifModel.Discretable;
import ru.autosome.commons.motifModel.HasLength;
import ru.autosome.commons.motifModel.ScoreDistribution;
import ru.autosome.commons.motifModel.types.DataModel;
import ru.autosome.macroape.calculation.generalized.ScanCollection;

public abstract class ScanCollection<ModelType extends Discretable<ModelType> & ScoreDistribution<BackgroundType>, BackgroundType extends GeneralizedBackgroundModel> {
    protected DataModel collectionDataModel;
    protected Double collectionEffectiveCount;
    protected PseudocountCalculator collectionPseudocount;
    protected DataModel queryDataModel;
    protected Double queryEffectiveCount;
    protected PseudocountCalculator queryPseudocount;
    protected BackgroundType queryBackground;
    protected BackgroundType collectionBackground;
    protected Discretizer roughDiscretizer;
    protected Discretizer preciseDiscretizer;
    protected Integer maxHashSize;
    protected Integer maxPairHashSize;
    protected double pvalue;
    protected Double queryPredefinedThreshold;
    protected Double similarityCutoff;
    protected Double preciseRecalculationCutoff;
    protected BoundaryType pvalueBoundaryType;
    protected String queryPMFilename;
    protected File pathToCollectionOfPWMs;
    protected File thresholds_folder;
    protected ModelType queryPWM;
    protected List<ThresholdEvaluator> pwmCollection;
    protected boolean queryTranspose;
    protected boolean collectionTranspose;

    protected abstract String DOC_background_option();

    protected abstract String DOC_run_string();

    protected String documentString() {
        return "Command-line format:\n" + this.DOC_run_string() + " <query PWM file> <folder with PWMs> [options]\n" + "\n" + "Options:\n" + "  [--pvalue <P-value>] or [-p]\n" + "  [--similarity-cutoff <similarity cutoff>] or [-c] minimal similarity to be included in output, '--similarity-cutoff 0.05' by default, [--all] to print all results\n" + "  [--precise [<level>]] minimal similarity to check on the second pass in precise mode, off by default, '--precise 0.01' if level is not set\n" + "  [--rough-discretization <discretization level>] or [-d]\n" + "  [--precise-discretization <discretization level>]\n" + "  [--[query-|collection-]pcm] - treat the query input file as Position Count Matrix. PCM-to-PWM transformation to be done internally.\n" + "  [--[query-|collection-]ppm] or [--pfm] - treat the query input file as Position Frequency Matrix. PPM-to-PWM transformation to be done internally.\n" + "  [--[query-|collection-]effective-count <count>] - effective samples set size for PPM-to-PWM conversion (default: 100). \n" + "  [--boundary lower|upper] Upper boundary (default) means that the obtained P-value is greater than or equal to the requested P-value\n" + "  [--background <background probabilities>] or [-b] " + this.DOC_background_option() + "\n" + "  [--precalc <folder>] - specify folder with thresholds for PWM collection (for fast-and-rough calculation).\n" + "                         Attention! Don't use threshold lists calculated for a different discretization (or background)!\n" + "  [--[query-|collection-]transpose] - load motif from transposed matrix (nucleotides in lines).\n" + this.DOC_additional_options() + "\n" + "Output format:\n" + "           <name> <jaccard index> <shift> <overlap> <orientation> ['*' in case that result was calculated on the second pass (in precise mode), '.' otherwise]\n" + "              Attention! Name can contain whitespace characters.\n" + "              Attention! The shift and orientation are reported for the collection matrix relative to the query matrix.\n" + "\n" + "Examples:\n" + "  " + this.DOC_run_string() + " ./query_motif.pwm ./hocomoco/ --precalc ./hocomoco_thresholds\n" + "  " + this.DOC_run_string() + " ./query_motif.pcm ./hocomoco/ --pcm -p 0.0005 --precise 0.03\n";
    }

    protected String DOC_additional_options() {
        return "";
    }

    protected void extract_query_pm_filename(ArrayList<String> argv) {
        if (argv.isEmpty()) {
            throw new IllegalArgumentException("No input. You should specify input file");
        }
        this.queryPMFilename = argv.remove(0);
    }

    protected void extract_path_to_collection_of_pwms(ArrayList<String> argv) {
        try {
            this.pathToCollectionOfPWMs = new File(argv.remove(0));
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Specify PWM-collection folder", e);
        }
    }

    protected abstract BackgroundType extractBackground(String var1);

    protected abstract void initialize_default_background();

    protected void initialize_defaults() {
        this.initialize_default_background();
        this.roughDiscretizer = new Discretizer(1.0);
        this.preciseDiscretizer = new Discretizer(10.0);
        this.maxHashSize = 10000000;
        this.maxPairHashSize = 10000;
        this.queryDataModel = DataModel.PWM;
        this.collectionDataModel = DataModel.PWM;
        this.queryEffectiveCount = 100.0;
        this.queryPseudocount = PseudocountCalculator.logPseudocount;
        this.collectionEffectiveCount = 100.0;
        this.collectionPseudocount = PseudocountCalculator.logPseudocount;
        this.thresholds_folder = null;
        this.pvalueBoundaryType = BoundaryType.UPPER;
        this.pvalue = 5.0E-4;
        this.similarityCutoff = 0.05;
        this.preciseRecalculationCutoff = null;
        this.queryTranspose = false;
        this.collectionTranspose = false;
    }

    protected void extract_option(ArrayList<String> argv) {
        String opt = argv.remove(0);
        if (opt.equals("-b") || opt.equals("--background")) {
            BackgroundType background = this.extractBackground(argv.remove(0));
            this.queryBackground = background;
            this.collectionBackground = background;
        } else if (opt.equals("--query-background")) {
            this.queryBackground = this.extractBackground(argv.remove(0));
        } else if (opt.equals("--collection-background")) {
            this.collectionBackground = this.extractBackground(argv.remove(0));
        } else if (opt.equals("--max-hash-size")) {
            this.maxHashSize = Integer.valueOf(argv.remove(0));
        } else if (opt.equals("--max-2d-hash-size")) {
            this.maxPairHashSize = Integer.valueOf(argv.remove(0));
        } else if (opt.equals("--rough-discretization") || opt.equals("-d") || opt.equals("--discretization")) {
            this.roughDiscretizer = Discretizer.fromString(argv.remove(0));
        } else if (opt.equals("--precise-discretization")) {
            this.preciseDiscretizer = Discretizer.fromString(argv.remove(0));
        } else if (opt.equals("--boundary")) {
            this.pvalueBoundaryType = BoundaryType.valueOf(argv.remove(0).toUpperCase());
        } else if (opt.equals("--pcm")) {
            this.queryDataModel = DataModel.PCM;
            this.collectionDataModel = DataModel.PCM;
        } else if (opt.equals("--query-pcm")) {
            this.queryDataModel = DataModel.PCM;
        } else if (opt.equals("--collection-pcm")) {
            this.collectionDataModel = DataModel.PCM;
        } else if (opt.equals("--ppm") || opt.equals("--pfm")) {
            this.queryDataModel = DataModel.PPM;
            this.collectionDataModel = DataModel.PPM;
        } else if (opt.equals("--query-ppm") || opt.equals("--query-pfm")) {
            this.queryDataModel = DataModel.PPM;
        } else if (opt.equals("--collection-ppm") || opt.equals("--collection-pfm")) {
            this.collectionDataModel = DataModel.PPM;
        } else if (opt.equals("--effective-count")) {
            Double effectiveCount;
            this.queryEffectiveCount = effectiveCount = Double.valueOf(argv.remove(0));
            this.collectionEffectiveCount = effectiveCount;
        } else if (opt.equals("--query-effective-count")) {
            this.queryEffectiveCount = Double.valueOf(argv.remove(0));
        } else if (opt.equals("--collection-effective-count")) {
            this.collectionEffectiveCount = Double.valueOf(argv.remove(0));
        } else if (opt.equals("--pseudocount")) {
            PseudocountCalculator pseudocount;
            this.queryPseudocount = pseudocount = PseudocountCalculator.fromString(argv.remove(0));
            this.collectionPseudocount = pseudocount;
        } else if (opt.equals("--query-pseudocount")) {
            this.queryPseudocount = PseudocountCalculator.fromString(argv.remove(0));
        } else if (opt.equals("--collection-pseudocount")) {
            this.collectionPseudocount = PseudocountCalculator.fromString(argv.remove(0));
        } else if (opt.equals("--precalc")) {
            this.thresholds_folder = new File(argv.remove(0));
        } else if (opt.equals("-p") || opt.equals("--pvalue")) {
            this.pvalue = Double.valueOf(argv.remove(0));
        } else if (opt.equals("--predefined-threshold")) {
            this.queryPredefinedThreshold = Double.valueOf(argv.remove(0));
        } else if (opt.equals("-c") || opt.equals("--similarity-cutoff")) {
            this.similarityCutoff = Double.valueOf(argv.remove(0));
        } else if (opt.equals("--all")) {
            this.similarityCutoff = 0.0;
        } else if (opt.equals("--precise")) {
            this.preciseRecalculationCutoff = !argv.isEmpty() && InputExtensions.isDouble(argv.get(0)) ? Double.valueOf(argv.remove(0)) : Double.valueOf(0.01);
        } else if (opt.equals("--transpose")) {
            this.queryTranspose = true;
            this.collectionTranspose = true;
        } else if (opt.equals("--query-transpose")) {
            this.queryTranspose = true;
        } else if (opt.equals("--collection-transpose")) {
            this.collectionTranspose = true;
        } else if (this.failed_to_recognize_additional_options(opt, argv)) {
            throw new IllegalArgumentException("Unknown option '" + opt + "'");
        }
    }

    protected boolean failed_to_recognize_additional_options(String opt, List<String> argv) {
        return true;
    }

    public OutputInformation report_table_layout() {
        OutputInformation infos = new OutputInformation();
        infos.add_parameter("MS", "minimal similarity to output", this.similarityCutoff);
        infos.add_parameter("P", "P-value", this.pvalue);
        infos.add_parameter("PB", "P-value boundary", (Object)this.pvalueBoundaryType);
        if (this.preciseRecalculationCutoff != null) {
            infos.add_parameter("VR", "discretization value, rough", this.roughDiscretizer);
            infos.add_parameter("VP", "discretization value, precise", this.preciseDiscretizer);
            infos.add_parameter("MP", "minimal similarity for the 2nd pass in 'precise' mode", this.preciseRecalculationCutoff);
        } else {
            infos.add_parameter("V", "discretization value", this.roughDiscretizer);
        }
        infos.background_parameter("BQ", "background for query matrix", (GeneralizedBackgroundModel)this.queryBackground);
        infos.background_parameter("BC", "background for collection", (GeneralizedBackgroundModel)this.collectionBackground);
        infos.add_table_parameter_without_description("motif", "name");
        infos.add_table_parameter_without_description("similarity", "similarity");
        infos.add_table_parameter_without_description("shift", "shift");
        infos.add_table_parameter_without_description("overlap", "overlap");
        infos.add_table_parameter_without_description("orientation", "orientation");
        if (this.preciseRecalculationCutoff != null) {
            infos.add_table_parameter_without_description("precise mode", "precision_mode", new OutputInformation.Callback<ScanCollection.SimilarityInfo>(){

                public String run(ScanCollection.SimilarityInfo cell) {
                    return cell.precise ? "*" : ".";
                }
            });
        }
        return infos;
    }

    protected OutputInformation report_table(List<? extends ResultInfo> data) {
        OutputInformation result = this.report_table_layout();
        Collections.sort(data, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                ScanCollection.SimilarityInfo s1 = (ScanCollection.SimilarityInfo)o1;
                ScanCollection.SimilarityInfo s2 = (ScanCollection.SimilarityInfo)o2;
                return s1.similarity().compareTo(s2.similarity());
            }
        });
        result.data = data;
        return result;
    }

    protected <R extends ResultInfo> OutputInformation report_table(R[] data) {
        ArrayList data_list = new ArrayList(data.length);
        Collections.addAll(data_list, data);
        return this.report_table(data_list);
    }

    protected List<? extends ResultInfo> process() throws Exception {
        List<ScanCollection.SimilarityInfo> infos = this.calculator().similarityInfos();
        return infos;
    }

    protected List<ThresholdEvaluator> load_collection_of_pwms() {
        List<Named<ModelType>> pwmList = this.loadMotifCollection();
        ArrayList<ThresholdEvaluator> result = new ArrayList<ThresholdEvaluator>();
        for (Named<ModelType> namedModel : pwmList) {
            Discretable pwm = (Discretable)namedModel.getObject();
            if (this.thresholds_folder == null) {
                result.add(new ThresholdEvaluator(this, pwm, namedModel.getName(), new FindThresholdAPE<Discretable, BackgroundType>(pwm, this.collectionBackground, this.roughDiscretizer, this.maxHashSize), new FindThresholdAPE<Discretable, BackgroundType>(pwm, this.collectionBackground, this.preciseDiscretizer, this.maxHashSize), new FindPvalueAPE<HasLength, BackgroundType>((HasLength)((Object)pwm), this.collectionBackground, this.roughDiscretizer, this.maxHashSize), new FindPvalueAPE<HasLength, BackgroundType>((HasLength)((Object)pwm), this.collectionBackground, this.preciseDiscretizer, this.maxHashSize)));
                continue;
            }
            result.add(new ThresholdEvaluator(this, pwm, namedModel.getName(), new FindThresholdBsearchBuilder(this.thresholds_folder).thresholdCalculator(namedModel.getName()), null, new FindPvalueBsearchBuilder(this.thresholds_folder).pvalueCalculator(namedModel.getName()), null));
        }
        return result;
    }

    protected void setup_from_arglist(ArrayList<String> argv) {
        this.extract_query_pm_filename(argv);
        this.extract_path_to_collection_of_pwms(argv);
        while (argv.size() > 0) {
            this.extract_option(argv);
        }
        this.queryPWM = this.loadQueryMotif();
        this.pwmCollection = this.load_collection_of_pwms();
    }

    protected abstract ru.autosome.macroape.calculation.generalized.ScanCollection<ModelType, BackgroundType> calculator();

    protected abstract List<Named<ModelType>> loadMotifCollection();

    protected abstract ModelType loadQueryMotif();

    public static class ThresholdEvaluator {
        public final ModelType pwm;
        public final String name;
        public final CanFindThreshold roughThresholdCalculator;
        public final CanFindThreshold preciseThresholdCalculator;
        public final CanFindPvalue roughPvalueCalculator;
        public final CanFindPvalue precisePvalueCalculator;
        final /* synthetic */ ScanCollection this$0;

        public ThresholdEvaluator(ModelType pwm, String name, CanFindThreshold roughThresholdCalculator, CanFindThreshold preciseThresholdCalculator, CanFindPvalue roughPvalueCalculator, CanFindPvalue precisePvalueCalculator) {
            this.this$0 = this$0;
            this.pwm = pwm;
            this.name = name;
            this.roughThresholdCalculator = roughThresholdCalculator;
            this.preciseThresholdCalculator = preciseThresholdCalculator;
            this.roughPvalueCalculator = roughPvalueCalculator;
            this.precisePvalueCalculator = precisePvalueCalculator;
        }
    }
}

