/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.macroape.di;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ru.autosome.commons.backgroundModel.di.DiBackground;
import ru.autosome.commons.backgroundModel.di.DiBackgroundModel;
import ru.autosome.commons.backgroundModel.di.DiWordwiseBackground;
import ru.autosome.commons.cli.Helper;
import ru.autosome.commons.cli.ResultInfo;
import ru.autosome.commons.importer.DiPWMFromMonoImporter;
import ru.autosome.commons.importer.DiPWMImporter;
import ru.autosome.commons.importer.MotifImporter;
import ru.autosome.commons.model.Named;
import ru.autosome.commons.motifModel.di.DiPWM;
import ru.autosome.macroape.cli.generalized.ScanCollection;

public class ScanCollection
extends ru.autosome.macroape.cli.generalized.ScanCollection<DiPWM, DiBackgroundModel> {
    boolean queryFromMononucleotide;
    boolean collectionFromMononucleotide;

    @Override
    protected String DOC_background_option() {
        return "ACGT - 16 numbers, comma-delimited(spaces not allowed), sum should be equal to 1, like 0.02,0.03,0.03,0.02,0.08,0.12,0.12,0.08,0.08,0.12,0.12,0.08,0.02,0.03,0.03,0.02";
    }

    @Override
    protected String DOC_run_string() {
        return "java ru.autosome.macroape.di.ScanCollection";
    }

    @Override
    protected String DOC_additional_options() {
        return "  [--query-from-mono]      - obtain query DiPWM from mono PWM/PCM/PPM.\n  [--collection-from-mono] - obtain collection DiPWMs from mono PWM/PCM/PPMs.\n";
    }

    @Override
    protected void initialize_defaults() {
        super.initialize_defaults();
        this.queryFromMononucleotide = false;
        this.collectionFromMononucleotide = false;
    }

    @Override
    protected boolean failed_to_recognize_additional_options(String opt, List<String> argv) {
        if (opt.equals("--query-from-mono")) {
            this.queryFromMononucleotide = true;
            return false;
        }
        if (opt.equals("--collection-from-mono")) {
            this.collectionFromMononucleotide = true;
            return false;
        }
        return true;
    }

    @Override
    protected DiBackgroundModel extractBackground(String str) {
        return DiBackground.fromString(str);
    }

    @Override
    protected void initialize_default_background() {
        this.queryBackground = new DiWordwiseBackground();
        this.collectionBackground = new DiWordwiseBackground();
    }

    private ScanCollection() {
        this.initialize_defaults();
    }

    private static ScanCollection from_arglist(ArrayList<String> argv) {
        ScanCollection result = new ScanCollection();
        Helper.print_help_if_requested(argv, new ScanCollection().documentString());
        result.setup_from_arglist(argv);
        return result;
    }

    private static ScanCollection from_arglist(String[] args) {
        ArrayList<String> argv = new ArrayList<String>();
        Collections.addAll(argv, args);
        return ScanCollection.from_arglist(argv);
    }

    @Override
    protected List<Named<DiPWM>> loadMotifCollection() {
        MotifImporter importer = this.collectionFromMononucleotide ? new DiPWMFromMonoImporter((DiBackgroundModel)this.collectionBackground, this.collectionDataModel, this.collectionEffectiveCount, this.collectionTranspose, this.collectionPseudocount) : new DiPWMImporter((DiBackgroundModel)this.collectionBackground, this.collectionDataModel, this.collectionEffectiveCount, this.collectionTranspose, this.collectionPseudocount);
        return importer.loadMotifCollectionWithNames(this.pathToCollectionOfPWMs);
    }

    @Override
    protected DiPWM loadQueryMotif() {
        MotifImporter importer = this.queryFromMononucleotide ? new DiPWMFromMonoImporter((DiBackgroundModel)this.queryBackground, this.queryDataModel, this.queryEffectiveCount, this.queryTranspose, this.queryPseudocount) : new DiPWMImporter((DiBackgroundModel)this.queryBackground, this.queryDataModel, this.queryEffectiveCount, this.queryTranspose, this.queryPseudocount);
        return (DiPWM)importer.loadMotif(this.queryPMFilename);
    }

    protected ru.autosome.macroape.calculation.di.ScanCollection calculator() {
        ru.autosome.macroape.calculation.di.ScanCollection calculator = new ru.autosome.macroape.calculation.di.ScanCollection((List<ScanCollection.ThresholdEvaluator>)this.pwmCollection, (DiPWM)this.queryPWM);
        calculator.pvalue = this.pvalue;
        calculator.queryPredefinedThreshold = this.queryPredefinedThreshold;
        calculator.roughDiscretizer = this.roughDiscretizer;
        calculator.preciseDiscretizer = this.preciseDiscretizer;
        calculator.queryBackground = this.queryBackground;
        calculator.collectionBackground = this.collectionBackground;
        calculator.pvalueBoundaryType = this.pvalueBoundaryType;
        calculator.maxHashSize = this.maxHashSize;
        calculator.maxPairHashSize = this.maxPairHashSize;
        calculator.similarityCutoff = this.similarityCutoff;
        calculator.preciseRecalculationCutoff = this.preciseRecalculationCutoff;
        return calculator;
    }

    public static void main(String[] args) {
        try {
            ScanCollection calculation = ScanCollection.from_arglist(args);
            List<ResultInfo> infos = calculation.process();
            System.out.println(calculation.report_table(infos).report());
        }
        catch (Exception err) {
            System.err.println("\n" + err.getMessage() + "\n--------------------------------------\n");
            err.printStackTrace();
            System.err.println("\n--------------------------------------\nUse --help option for help\n\n" + new ScanCollection().documentString());
            System.exit(1);
        }
    }
}

