/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.macroape.example;

import ru.autosome.ape.calculation.findPvalue.CanFindPvalue;
import ru.autosome.ape.calculation.findPvalue.FindPvalueAPE;
import ru.autosome.commons.backgroundModel.di.DiWordwiseBackground;
import ru.autosome.commons.backgroundModel.mono.WordwiseBackground;
import ru.autosome.commons.importer.PWMImporter;
import ru.autosome.commons.model.Discretizer;
import ru.autosome.commons.motifModel.di.DiPWM;
import ru.autosome.commons.motifModel.mono.PWM;
import ru.autosome.macroape.calculation.di.CompareModels;
import ru.autosome.macroape.calculation.generalized.CompareModelsCountsGiven;

public class EvaluateSimilarity {
    public static void main(String[] args) {
        PWM firstPWM = (PWM)new PWMImporter().loadMotif("test_data/pwm/KLF4_f2.pwm");
        PWM secondPWM = (PWM)new PWMImporter().loadMotif("test_data/pwm/SP1_f1.pwm");
        try {
            Discretizer discretizer = new Discretizer(100.0);
            WordwiseBackground background = new WordwiseBackground();
            ru.autosome.macroape.calculation.mono.CompareModels comparator = new ru.autosome.macroape.calculation.mono.CompareModels(firstPWM, secondPWM, background, background, discretizer, null, null);
            CompareModelsCountsGiven.SimilarityInfo similarityInfo = comparator.jaccard_by_weak_pvalue(5.0E-4);
            System.out.println("\n----------\n" + similarityInfo.similarity());
            System.out.println(similarityInfo.alignment);
            System.out.println(similarityInfo.recognizedByBoth);
            DiPWM firstDiPWM = DiPWM.fromPWM(firstPWM);
            DiPWM secondDiPWM = DiPWM.fromPWM(secondPWM);
            DiWordwiseBackground dibackground = new DiWordwiseBackground();
            CompareModels dicomparator = new CompareModels(firstDiPWM, secondDiPWM, dibackground, dibackground, (CanFindPvalue)new FindPvalueAPE<DiPWM, DiWordwiseBackground>(firstDiPWM, dibackground, discretizer, null), (CanFindPvalue)new FindPvalueAPE<DiPWM, DiWordwiseBackground>(secondDiPWM, dibackground, discretizer, null), discretizer, null);
            CompareModelsCountsGiven.SimilarityInfo diSimilarityInfo = dicomparator.jaccard_by_weak_pvalue(5.0E-4);
            System.out.println("\n----------\n" + diSimilarityInfo.similarity());
            System.out.println(diSimilarityInfo.alignment);
            System.out.println(diSimilarityInfo.recognizedByBoth);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

