/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.perfectosape.calculation;

import ru.autosome.commons.model.Orientation;
import ru.autosome.commons.model.Position;
import ru.autosome.commons.model.PositionInterval;
import ru.autosome.commons.motifModel.HasLength;
import ru.autosome.commons.motifModel.ScoringModel;

public class ScanSequence<SequenceType extends HasLength> {
    private final SequenceType sequence;
    private final ScoringModel<SequenceType> pwm;
    final PositionInterval positions_to_check;
    Boolean cacheBest;
    Position cache_bestPosition;
    double cache_bestScore;

    public ScanSequence(SequenceType sequence, ScoringModel<SequenceType> pwm, PositionInterval positions_to_check) {
        if (sequence.length() < pwm.length()) {
            throw new IllegalArgumentException("Can't scan sequence '" + sequence + "' (length " + sequence.length() + ") with motif of length " + pwm.length());
        }
        this.sequence = sequence;
        this.pwm = pwm;
        this.positions_to_check = positions_to_check;
    }

    public void findBest() {
        if (this.cacheBest == null) {
            BestPositionWithScore bestPos = this.positions_to_check.findBestPosition(this.sequence, this.pwm);
            this.cache_bestScore = bestPos.getScore();
            this.cache_bestPosition = bestPos.getPosition();
            this.cacheBest = true;
        }
    }

    public Position best_position() {
        this.findBest();
        return this.cache_bestPosition;
    }

    public double best_score() {
        this.findBest();
        return this.cache_bestScore;
    }

    public static class BestPositionWithScore {
        private int position;
        private Orientation orientation;
        private double score = Double.NEGATIVE_INFINITY;

        public void updateBestScore(int newPosition, Orientation newOrientation, double newScore) {
            if (newScore > this.score) {
                this.score = newScore;
                this.position = newPosition;
                this.orientation = newOrientation;
            }
        }

        public double getScore() {
            return this.score;
        }

        public Position getPosition() {
            return new Position(this.position, this.orientation);
        }
    }
}

