/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.perfectosape.model;

import gnu.trove.impl.unmodifiable.TUnmodifiableCharCharMap;
import gnu.trove.map.TCharCharMap;
import gnu.trove.map.hash.TCharCharHashMap;
import gnu.trove.set.TCharSet;
import gnu.trove.set.hash.TCharHashSet;
import ru.autosome.commons.model.Alphabet;
import ru.autosome.commons.model.Position;
import ru.autosome.perfectosape.model.encoded.di.SequenceDiEncoded;
import ru.autosome.perfectosape.model.encoded.mono.SequenceMonoEncoded;

public class Sequence {
    private static final TCharSet allowedLetters = new TCharHashSet(new char[]{'A', 'C', 'G', 'T', 'a', 'c', 'g', 't', 'n', 'N'});
    private static final TCharCharMap complements = new TUnmodifiableCharCharMap(new TCharCharHashMap(new char[]{'A', 'C', 'G', 'T', 'a', 'c', 'g', 't', 'n', 'N'}, new char[]{'T', 'G', 'C', 'A', 't', 'g', 'c', 'a', 'n', 'N'}));
    public final String sequence;
    private String cache_reverseComplementString;
    private SequenceMonoEncoded cache_monoEncode;
    private SequenceDiEncoded cache_diEncode;

    public Sequence(String sequence, boolean checked) {
        if (!checked) {
            for (int i = 0; i < sequence.length(); ++i) {
                if (allowedLetters.containsAll(sequence.toCharArray())) continue;
                throw new IllegalArgumentException("Sequence '" + sequence + "' contains unallowed character (only A,C,G,T,N letters are allowed).");
            }
        }
        this.sequence = sequence;
    }

    public Sequence(String sequence) {
        this(sequence, false);
    }

    public int length() {
        return this.sequence.length();
    }

    public Sequence reverse() {
        return new Sequence(new StringBuilder(this.sequence).reverse().toString(), true);
    }

    public Sequence reverseComplement() {
        int len = this.sequence.length();
        StringBuilder revCompSeq = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            revCompSeq.append(complements.get(this.sequence.charAt(len - 1 - i)));
        }
        return new Sequence(revCompSeq.toString(), true);
    }

    private String reverseComplementString() {
        if (this.cache_reverseComplementString == null) {
            String revSeq = new StringBuilder(this.sequence).reverse().toString();
            StringBuilder revCompSeq = new StringBuilder(revSeq.length());
            for (int i = 0; i < revSeq.length(); ++i) {
                revCompSeq.append(complements.get(revSeq.charAt(i)));
            }
            this.cache_reverseComplementString = revCompSeq.toString();
        }
        return this.cache_reverseComplementString;
    }

    public Sequence complement() {
        return new Sequence(this.reverseComplementString(), true);
    }

    public Sequence substring(int beginIndex, int endIndex) {
        return new Sequence(this.sequence.substring(beginIndex, endIndex), true);
    }

    public Sequence substring(Position left_boundary, int substring_length) {
        Sequence unorientedWord = this.substring(left_boundary.position(), Math.min(left_boundary.position() + substring_length, this.length()));
        if (left_boundary.isDirect()) {
            return unorientedWord;
        }
        return unorientedWord.reverseComplement();
    }

    public SequenceMonoEncoded monoEncode() {
        if (this.cache_monoEncode == null) {
            byte[] directSeq = Alphabet.monoACGTN.convertString(this.sequence);
            byte[] revcompSeq = Alphabet.monoACGTN.convertString(this.reverseComplementString());
            this.cache_monoEncode = new SequenceMonoEncoded(directSeq, revcompSeq);
        }
        return this.cache_monoEncode;
    }

    public SequenceDiEncoded diEncode() {
        if (this.cache_diEncode == null) {
            byte[] directSeq = Alphabet.diACGTN.convertString(this.sequence);
            byte[] revcompSeq = Alphabet.diACGTN.convertString(this.reverseComplementString());
            this.cache_diEncode = new SequenceDiEncoded(directSeq, revcompSeq);
        }
        return this.cache_diEncode;
    }

    public String toString() {
        return this.sequence;
    }
}

