/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.perfectosape.model;

import gnu.trove.set.TCharSet;
import gnu.trove.set.hash.TCharHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.autosome.commons.model.Position;
import ru.autosome.commons.model.PositionInterval;
import ru.autosome.perfectosape.model.Sequence;
import ru.autosome.perfectosape.model.encoded.di.SequenceDiEncoded;
import ru.autosome.perfectosape.model.encoded.di.SequenceWithSNPDiEncoded;
import ru.autosome.perfectosape.model.encoded.mono.SequenceMonoEncoded;
import ru.autosome.perfectosape.model.encoded.mono.SequenceWithSNPMonoEncoded;

public class SequenceWithSNP {
    private static final TCharSet allowedLetters = new TCharHashSet(new char[]{'A', 'C', 'G', 'T', 'a', 'c', 'g', 't', 'n', 'N'});
    static Pattern SNVSequencePattern = Pattern.compile("([ACGTN]*)\\[([ACGTN](?:/[ACGTN])+)\\]([ACGTN]*)", 2);
    public final String left;
    public final String right;
    public final char[] mid;
    private Sequence[] cache_sequence_variants;

    public SequenceWithSNP(String left, char[] mid, String right) {
        if (!allowedLetters.containsAll(left.toCharArray())) {
            throw new IllegalArgumentException("Sequence '" + left + "' (left part of SNP) contains unallowed character (only A,C,G,T,N letters are allowed).");
        }
        if (!allowedLetters.containsAll(right.toCharArray())) {
            throw new IllegalArgumentException("Sequence '" + right + "' (right part of SNP) contains unallowed character (only A,C,G,T,N letters are allowed).");
        }
        if (!allowedLetters.containsAll(mid)) {
            throw new IllegalArgumentException("SNP variants: '" + new String(mid) + "' contain unallowed character (only A,C,G,T,N letters are allowed).");
        }
        this.left = left.toLowerCase();
        char[] mid_upcased = new char[mid.length];
        for (int i = 0; i < mid.length; ++i) {
            mid_upcased[i] = Character.toUpperCase(mid[i]);
        }
        this.mid = mid_upcased;
        this.right = right.toLowerCase();
    }

    public static SequenceWithSNP fromString(String seq_w_snp) {
        Matcher matcher = SNVSequencePattern.matcher(seq_w_snp);
        if (matcher.find()) {
            String left = matcher.group(1);
            String mid_str = matcher.group(2);
            char[] mid = mid_str.replaceAll("/", "").toCharArray();
            String right = matcher.group(3);
            return new SequenceWithSNP(left, mid, right);
        }
        throw new IllegalArgumentException("Can't parse sequence with SNPs: " + seq_w_snp);
    }

    int pos_of_snp() {
        return this.left.length();
    }

    public int num_cases() {
        return this.mid.length;
    }

    public Sequence[] sequence_variants() {
        if (this.cache_sequence_variants == null) {
            this.cache_sequence_variants = new Sequence[this.num_cases()];
            for (int i = 0; i < this.num_cases(); ++i) {
                this.cache_sequence_variants[i] = new Sequence(this.left + this.mid[i] + this.right, true);
            }
        }
        return this.cache_sequence_variants;
    }

    public int length() {
        return this.left.length() + 1 + this.right.length();
    }

    public PositionInterval positionsOverlappingSNV(int subsequence_length) {
        int left_pos = Math.max(0, this.left.length() - subsequence_length + 1);
        int right_pos = Math.min(this.length(), this.left.length() + subsequence_length);
        return Position.positions_between(left_pos, right_pos, subsequence_length);
    }

    public String toString() {
        String mid_variants = "" + this.mid[0];
        for (int i = 1; i < this.num_cases(); ++i) {
            mid_variants = mid_variants + "/" + this.mid[i];
        }
        return this.left + "[" + mid_variants + "]" + this.right;
    }

    public SequenceWithSNPMonoEncoded monoEncode() {
        ArrayList<SequenceMonoEncoded> encodedVariants = new ArrayList<SequenceMonoEncoded>(this.num_cases());
        for (Sequence seq : this.sequence_variants()) {
            encodedVariants.add(seq.monoEncode());
        }
        return new SequenceWithSNPMonoEncoded(encodedVariants);
    }

    public SequenceWithSNPDiEncoded diEncode() {
        ArrayList<SequenceDiEncoded> encodedVariants = new ArrayList<SequenceDiEncoded>(this.num_cases());
        for (Sequence seq : this.sequence_variants()) {
            encodedVariants.add(seq.diEncode());
        }
        return new SequenceWithSNPDiEncoded(encodedVariants);
    }

    private String polyNString(int len) {
        char[] buf = new char[len];
        Arrays.fill(buf, 'N');
        return new String(buf);
    }

    public SequenceWithSNP expandFlanksUpTo(int sequenceRadius) {
        int leftExpansionLength = Math.max(sequenceRadius - 1 - this.left.length(), 0);
        int rightExpansionLength = Math.max(sequenceRadius - 1 - this.right.length(), 0);
        return new SequenceWithSNP(this.polyNString(leftExpansionLength) + this.left, this.mid, this.right + this.polyNString(rightExpansionLength));
    }
}

