/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.ape.calculation;

import java.util.ArrayList;
import ru.autosome.ape.calculation.findThreshold.CanFindThreshold;
import ru.autosome.ape.calculation.findThreshold.FindThresholdAPE;
import ru.autosome.ape.model.PvalueBsearchList;
import ru.autosome.ape.model.exception.HashOverflowException;
import ru.autosome.ape.model.progression.GeometricProgression;
import ru.autosome.commons.model.BoundaryType;
import ru.autosome.commons.model.Discretizer;
import ru.autosome.commons.motifModel.Discretable;
import ru.autosome.commons.motifModel.ScoreBoundaries;
import ru.autosome.commons.motifModel.ScoreDistribution;

public class PrecalculateThresholdList<ModelType extends Discretable<ModelType> & ScoreDistribution<BackgroundType>, BackgroundType> {
    public static final double[] PVALUE_LIST = new GeometricProgression(1.0, 1.0E-15, 1.05).values();
    final double[] pvalues;
    final BoundaryType pvalue_boundary;
    final Discretizer discretizer;
    final BackgroundType background;
    final Integer max_hash_size;

    public PrecalculateThresholdList(double[] pvalues, Discretizer discretizer, BackgroundType background, BoundaryType pvalue_boundary, Integer max_hash_size) {
        this.pvalues = pvalues;
        this.discretizer = discretizer;
        this.background = background;
        this.pvalue_boundary = pvalue_boundary;
        this.max_hash_size = max_hash_size;
    }

    protected CanFindThreshold find_threshold_calculator(ModelType motif) {
        return new FindThresholdAPE<ModelType, BackgroundType>(motif, this.background, this.discretizer, this.max_hash_size);
    }

    public PvalueBsearchList bsearch_list_for_pwm(ModelType motif) throws HashOverflowException {
        CanFindThreshold.ThresholdInfo[] infos = this.find_threshold_calculator(motif).thresholdsByPvalues(this.pvalues, this.pvalue_boundary);
        ArrayList<PvalueBsearchList.ThresholdPvaluePair> pairs = new ArrayList<PvalueBsearchList.ThresholdPvaluePair>(infos.length + 2);
        for (CanFindThreshold.ThresholdInfo info : infos) {
            pairs.add(new PvalueBsearchList.ThresholdPvaluePair(info));
        }
        double worstScore = ((ScoreBoundaries)motif).worst_score();
        double bestScore = ((ScoreBoundaries)motif).best_score();
        double eps = 1.0;
        if (bestScore - worstScore > 0.0 && bestScore - worstScore < eps) {
            eps = bestScore - worstScore;
        }
        pairs.add(new PvalueBsearchList.ThresholdPvaluePair(worstScore, 1.0));
        pairs.add(new PvalueBsearchList.ThresholdPvaluePair(bestScore + (eps *= 0.1), 0.0));
        return new PvalueBsearchList(pairs);
    }
}

