/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.ape.calculation.findThreshold;

import ru.autosome.ape.model.exception.HashOverflowException;
import ru.autosome.commons.backgroundModel.GeneralizedBackgroundModel;
import ru.autosome.commons.cli.ResultInfo;
import ru.autosome.commons.model.BoundaryType;
import ru.autosome.commons.model.Discretizer;

public interface CanFindThreshold {
    public ThresholdInfo weakThresholdByPvalue(double var1) throws HashOverflowException;

    public ThresholdInfo strongThresholdByPvalue(double var1) throws HashOverflowException;

    public ThresholdInfo thresholdByPvalue(double var1, BoundaryType var3) throws HashOverflowException;

    public ThresholdInfo[] weakThresholdsByPvalues(double[] var1) throws HashOverflowException;

    public ThresholdInfo[] strongThresholsdByPvalues(double[] var1) throws HashOverflowException;

    public ThresholdInfo[] thresholdsByPvalues(double[] var1, BoundaryType var2) throws HashOverflowException;

    public static class ThresholdInfo
    extends ResultInfo {
        public final double threshold;
        public final double real_pvalue;
        public final double expected_pvalue;

        public ThresholdInfo(double threshold, double real_pvalue, double expected_pvalue) {
            this.threshold = threshold;
            this.real_pvalue = real_pvalue;
            this.expected_pvalue = expected_pvalue;
        }

        public double numberOfRecognizedWords(GeneralizedBackgroundModel background, int length) {
            return this.real_pvalue * Math.pow(background.volume(), length);
        }

        public ThresholdInfo downscale(Discretizer discretizer) {
            return new ThresholdInfo(discretizer.downscale(this.threshold), this.real_pvalue, this.expected_pvalue);
        }
    }
}

