/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.ape.calculation.findThreshold;

import ru.autosome.ape.calculation.findThreshold.CanFindThreshold;
import ru.autosome.ape.model.PvalueBsearchList;
import ru.autosome.ape.model.exception.HashOverflowException;
import ru.autosome.commons.model.BoundaryType;

public class FindThresholdBsearch
implements CanFindThreshold {
    final PvalueBsearchList bsearchList;

    FindThresholdBsearch(PvalueBsearchList bsearchList) {
        this.bsearchList = bsearchList;
    }

    @Override
    public CanFindThreshold.ThresholdInfo weakThresholdByPvalue(double pvalue) throws HashOverflowException {
        PvalueBsearchList.ThresholdPvaluePair info = this.bsearchList.weakThresholdByPvalue(pvalue);
        double threshold = info.threshold;
        double real_pvalue = info.pvalue;
        return new CanFindThreshold.ThresholdInfo(threshold, real_pvalue, pvalue);
    }

    @Override
    public CanFindThreshold.ThresholdInfo strongThresholdByPvalue(double pvalue) throws HashOverflowException {
        PvalueBsearchList.ThresholdPvaluePair info = this.bsearchList.strongThresholdInfoByPvalue(pvalue);
        double threshold = info.threshold;
        double real_pvalue = info.pvalue;
        return new CanFindThreshold.ThresholdInfo(threshold, real_pvalue, pvalue);
    }

    @Override
    public CanFindThreshold.ThresholdInfo thresholdByPvalue(double pvalue, BoundaryType boundaryType) throws HashOverflowException {
        if (boundaryType == BoundaryType.LOWER) {
            return this.strongThresholdByPvalue(pvalue);
        }
        return this.weakThresholdByPvalue(pvalue);
    }

    @Override
    public CanFindThreshold.ThresholdInfo[] weakThresholdsByPvalues(double[] pvalues) throws HashOverflowException {
        CanFindThreshold.ThresholdInfo[] result = new CanFindThreshold.ThresholdInfo[pvalues.length];
        for (int i = 0; i < pvalues.length; ++i) {
            result[i] = this.weakThresholdByPvalue(pvalues[i]);
        }
        return result;
    }

    @Override
    public CanFindThreshold.ThresholdInfo[] strongThresholsdByPvalues(double[] pvalues) throws HashOverflowException {
        CanFindThreshold.ThresholdInfo[] result = new CanFindThreshold.ThresholdInfo[pvalues.length];
        for (int i = 0; i < pvalues.length; ++i) {
            result[i] = this.strongThresholdByPvalue(pvalues[i]);
        }
        return result;
    }

    @Override
    public CanFindThreshold.ThresholdInfo[] thresholdsByPvalues(double[] pvalues, BoundaryType boundaryType) throws HashOverflowException {
        CanFindThreshold.ThresholdInfo[] result = new CanFindThreshold.ThresholdInfo[pvalues.length];
        for (int i = 0; i < pvalues.length; ++i) {
            result[i] = this.thresholdByPvalue(pvalues[i], boundaryType);
        }
        return result;
    }
}

