/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.ape.di;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ru.autosome.ape.calculation.findPvalue.CanFindPvalue;
import ru.autosome.ape.calculation.findPvalue.FindPvalueAPE;
import ru.autosome.ape.calculation.findPvalue.FindPvalueBsearchBuilder;
import ru.autosome.commons.backgroundModel.GeneralizedBackgroundModel;
import ru.autosome.commons.backgroundModel.di.DiBackground;
import ru.autosome.commons.backgroundModel.di.DiBackgroundModel;
import ru.autosome.commons.backgroundModel.di.DiWordwiseBackground;
import ru.autosome.commons.cli.Helper;
import ru.autosome.commons.importer.DiPWMFromMonoImporter;
import ru.autosome.commons.importer.DiPWMImporter;
import ru.autosome.commons.importer.MotifImporter;
import ru.autosome.commons.model.Named;
import ru.autosome.commons.motifModel.HasLength;
import ru.autosome.commons.motifModel.di.DiPWM;

public class FindPvalue
extends ru.autosome.ape.cli.generalized.FindPvalue<DiPWM, DiBackgroundModel> {
    boolean fromMononucleotide;

    @Override
    protected String DOC_background_option() {
        return "ACGT - 16 numbers, comma-delimited(spaces not allowed), sum should be equal to 1, like 0.02,0.03,0.03,0.02,0.08,0.12,0.12,0.08,0.08,0.12,0.12,0.08,0.02,0.03,0.03,0.02";
    }

    @Override
    protected String DOC_run_string() {
        return "java ru.autosome.ape.di.FindPvalue";
    }

    @Override
    protected String DOC_additional_options() {
        return "  [--from-mono]  - obtain DiPWM from mono PWM/PCM/PPM.\n";
    }

    @Override
    protected CanFindPvalue calculator() {
        if (this.cache_calculator == null) {
            this.cache_calculator = this.thresholds_folder == null ? new FindPvalueAPE<HasLength, GeneralizedBackgroundModel>((HasLength)this.motif.getObject(), (GeneralizedBackgroundModel)this.background, this.discretizer, this.max_hash_size) : new FindPvalueBsearchBuilder(this.thresholds_folder).pvalueCalculator(this.motif.getName());
        }
        return this.cache_calculator;
    }

    @Override
    protected void initialize_defaults() {
        super.initialize_defaults();
        this.fromMononucleotide = false;
    }

    @Override
    protected void initialize_default_background() {
        this.background = new DiWordwiseBackground();
    }

    @Override
    protected void extract_background(String str) {
        this.background = DiBackground.fromString(str);
    }

    @Override
    protected boolean failed_to_recognize_additional_options(String opt, List<String> argv) {
        if (opt.equals("--from-mono")) {
            this.fromMononucleotide = true;
            return false;
        }
        return true;
    }

    @Override
    protected Named<DiPWM> loadMotif(String filename) {
        MotifImporter importer = this.fromMononucleotide ? new DiPWMFromMonoImporter((DiBackgroundModel)this.background, this.data_model, (Double)this.effective_count, this.transpose, this.pseudocount) : new DiPWMImporter((DiBackgroundModel)this.background, this.data_model, this.effective_count, this.transpose, this.pseudocount);
        return importer.loadMotifWithName(filename);
    }

    protected FindPvalue() {
        this.initialize_defaults();
    }

    protected static FindPvalue from_arglist(ArrayList<String> argv) {
        FindPvalue result = new FindPvalue();
        Helper.print_help_if_requested(argv, result.documentString());
        result.setup_from_arglist(argv);
        return result;
    }

    protected static FindPvalue from_arglist(String[] args) {
        ArrayList<String> argv = new ArrayList<String>();
        Collections.addAll(argv, args);
        return FindPvalue.from_arglist(argv);
    }

    public static void main(String[] args) {
        try {
            FindPvalue cli = FindPvalue.from_arglist(args);
            System.out.println(cli.report_table().report());
        }
        catch (Exception err) {
            System.err.println("\n" + err.getMessage() + "\n--------------------------------------\n");
            err.printStackTrace();
            System.err.println("\n--------------------------------------\nUse --help option for help\n\n" + new FindPvalue().documentString());
            System.exit(1);
        }
    }
}

