/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.ape.model;

import gnu.trove.iterator.TDoubleDoubleIterator;
import gnu.trove.map.TDoubleDoubleMap;
import gnu.trove.map.TDoubleObjectMap;
import gnu.trove.map.hash.TDoubleDoubleHashMap;
import gnu.trove.map.hash.TDoubleObjectHashMap;
import java.util.ArrayList;
import java.util.List;
import ru.autosome.ape.calculation.findThreshold.CanFindThreshold;
import ru.autosome.commons.model.BoundaryType;
import ru.autosome.commons.support.ArrayExtensions;

public class ScoreDistributionTop {
    private final double left_score_boundary;
    private final TDoubleDoubleMap score_count_hash;
    private final double total_count;
    private Double cache_best_score;
    private Double cache_worst_score;

    public double getWorstScore() {
        if (this.cache_worst_score != null) {
            return this.cache_worst_score;
        }
        return Double.NEGATIVE_INFINITY;
    }

    public void setWorstScore(double value) {
        this.cache_worst_score = value;
    }

    public double getBestScore() {
        if (this.cache_best_score == null) {
            double max_score = Double.NEGATIVE_INFINITY;
            TDoubleDoubleIterator iterator = this.score_count_hash.iterator();
            while (iterator.hasNext()) {
                iterator.advance();
                double score = iterator.key();
                max_score = Math.max(score, max_score);
            }
            this.cache_best_score = max_score;
        }
        return this.cache_best_score;
    }

    public void setBestScore(double value) {
        this.cache_best_score = value;
    }

    public ScoreDistributionTop(TDoubleDoubleMap score_count_hash, double total_count, double left_score_boundary) {
        this.score_count_hash = score_count_hash;
        this.total_count = total_count;
        this.left_score_boundary = left_score_boundary;
    }

    public TDoubleDoubleMap counts_above_thresholds(double[] thresholds) throws NotRepresentativeDistribution {
        TDoubleDoubleHashMap result = new TDoubleDoubleHashMap();
        for (double threshold : thresholds) {
            result.put(threshold, this.count_above_threshold(threshold));
        }
        return result;
    }

    public double count_above_threshold(double threshold) throws NotRepresentativeDistribution {
        if (threshold < this.left_score_boundary) {
            throw new NotRepresentativeDistribution("Score distribution left boundary " + this.left_score_boundary + " is greater than requested threshold " + threshold);
        }
        double accum = 0.0;
        TDoubleDoubleIterator iterator = this.score_count_hash.iterator();
        while (iterator.hasNext()) {
            iterator.advance();
            double score = iterator.key();
            double count = iterator.value();
            if (!(score >= threshold)) continue;
            accum += count;
        }
        return accum;
    }

    ThresholdsRange thresholdsRangeByCount(double[] scores, List<Double> partial_sums, double look_for_count) {
        int[] range_indices = ArrayExtensions.indices_of_range(partial_sums, look_for_count);
        if (range_indices[0] == -1) {
            return new ThresholdsRange(scores[0], this.getBestScore() + 1.0, partial_sums.get(0), 0.0);
        }
        if (range_indices[0] == partial_sums.size()) {
            return new ThresholdsRange(this.getWorstScore() - 1.0, scores[scores.length - 1], this.total_count, partial_sums.get(scores.length - 1));
        }
        return new ThresholdsRange(scores[range_indices[1]], scores[range_indices[0]], partial_sums.get(range_indices[1]), partial_sums.get(range_indices[0]));
    }

    public double top_part_count() {
        double accum = 0.0;
        TDoubleDoubleIterator iterator = this.score_count_hash.iterator();
        while (iterator.hasNext()) {
            iterator.advance();
            double count = iterator.value();
            accum += count;
        }
        return accum;
    }

    public double top_part_pvalue() {
        return this.top_part_count() / this.total_count;
    }

    public TDoubleObjectMap<ThresholdsRange> thresholds_by_pvalues(double[] pvalues) throws NotRepresentativeDistribution {
        double eps = 1.0E-10;
        if (this.top_part_pvalue() + eps < ArrayExtensions.max(pvalues)) {
            throw new NotRepresentativeDistribution("Score distribution covers values up to pvalue " + this.top_part_pvalue() + " but pvalue " + ArrayExtensions.max(pvalues) + " was requested");
        }
        double[] scores = ArrayExtensions.descending_sorted_hash_keys(this.score_count_hash);
        double[] counts = new double[scores.length];
        for (int i = 0; i < scores.length; ++i) {
            counts[i] = this.score_count_hash.get(scores[i]);
        }
        ArrayList<Double> partial_sums = ArrayExtensions.partial_sums(counts, 0.0);
        TDoubleObjectHashMap<ThresholdsRange> results = new TDoubleObjectHashMap<ThresholdsRange>();
        for (double pvalue : pvalues) {
            double look_for_count = pvalue * this.total_count;
            results.put(pvalue, this.thresholdsRangeByCount(scores, partial_sums, look_for_count));
        }
        return results;
    }

    public CanFindThreshold.ThresholdInfo[] strong_thresholds(double[] pvalues) throws NotRepresentativeDistribution {
        return this.thresholds(pvalues, BoundaryType.LOWER);
    }

    public CanFindThreshold.ThresholdInfo strong_threshold(double pvalue) throws NotRepresentativeDistribution {
        return this.strong_thresholds(new double[]{pvalue})[0];
    }

    public CanFindThreshold.ThresholdInfo[] weak_thresholds(double[] pvalues) throws NotRepresentativeDistribution {
        return this.thresholds(pvalues, BoundaryType.UPPER);
    }

    public CanFindThreshold.ThresholdInfo weak_threshold(double pvalue) throws NotRepresentativeDistribution {
        return this.weak_thresholds(new double[]{pvalue})[0];
    }

    public CanFindThreshold.ThresholdInfo[] thresholds(double[] pvalues, BoundaryType pvalueBoundary) throws NotRepresentativeDistribution {
        ArrayList<CanFindThreshold.ThresholdInfo> results = new ArrayList<CanFindThreshold.ThresholdInfo>();
        TDoubleObjectMap<ThresholdsRange> thresholds_by_pvalues = this.thresholds_by_pvalues(pvalues);
        for (int i = 0; i < pvalues.length; ++i) {
            double real_pvalue;
            double threshold;
            double pvalue = pvalues[i];
            ThresholdsRange range = thresholds_by_pvalues.get(pvalue);
            if (pvalueBoundary == BoundaryType.LOWER) {
                threshold = range.first_threshold + 0.1 * (range.second_threshold - range.first_threshold);
                real_pvalue = range.second_count / this.total_count;
            } else {
                threshold = range.first_threshold;
                real_pvalue = range.first_count / this.total_count;
            }
            results.add(new CanFindThreshold.ThresholdInfo(threshold, real_pvalue, pvalue));
        }
        return results.toArray(new CanFindThreshold.ThresholdInfo[results.size()]);
    }

    public CanFindThreshold.ThresholdInfo threshold(double pvalue, BoundaryType pvalueBoundary) throws NotRepresentativeDistribution {
        return this.thresholds(new double[]{pvalue}, pvalueBoundary)[0];
    }

    public static class ThresholdsRange {
        final double first_threshold;
        final double second_threshold;
        final double first_count;
        final double second_count;

        ThresholdsRange(double first_threshold, double second_threshold, double first_count, double second_count) {
            this.first_threshold = first_threshold;
            this.second_threshold = second_threshold;
            this.first_count = first_count;
            this.second_count = second_count;
        }
    }

    public static class NotRepresentativeDistribution
    extends Exception {
        public NotRepresentativeDistribution() {
        }

        public NotRepresentativeDistribution(String msg) {
            super(msg);
        }
    }
}

