/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.commons.backgroundModel.mono;

import java.util.List;
import ru.autosome.commons.backgroundModel.di.DiBackgroundModel;
import ru.autosome.commons.backgroundModel.mono.BackgroundModel;
import ru.autosome.commons.backgroundModel.mono.WordwiseBackground;
import ru.autosome.commons.importer.InputExtensions;
import ru.autosome.commons.support.ArrayExtensions;

public class Background
implements BackgroundModel {
    private double[] background;

    public Background(double[] background) {
        if (background.length != 4) {
            throw new IllegalArgumentException("Background constructor takes an array of 4 frequencies");
        }
        if (Math.abs(ArrayExtensions.sum(background) - 1.0) > 1.0E-4) {
            throw new IllegalArgumentException("Background probabilities should be 1.0 being summarized");
        }
        this.background = background;
    }

    public Background(List<Double> background) {
        double[] background_array = ArrayExtensions.toPrimitiveArray(background);
        if (background_array.length != 4) {
            throw new IllegalArgumentException("Background constructor takes an array of 4 frequencies");
        }
        if (Math.abs(ArrayExtensions.sum(background_array) - 1.0) > 1.0E-4) {
            throw new IllegalArgumentException("Background probabilities should be 1.0 being summarized");
        }
        this.background = background_array;
    }

    public static BackgroundModel fromDiBackground(DiBackgroundModel backgroundModel) {
        if (backgroundModel.is_wordwise()) {
            return new WordwiseBackground();
        }
        double[] background = new double[4];
        for (int letter = 0; letter < 4; ++letter) {
            double sum = 0.0;
            for (int anotherLetter = 0; anotherLetter < 4; ++anotherLetter) {
                sum += backgroundModel.probability(4 * letter + anotherLetter) + backgroundModel.probability(4 * anotherLetter + letter);
            }
            background[letter] = sum / 2.0;
        }
        return new Background(background);
    }

    @Override
    public double probability(int index) {
        return this.background[index];
    }

    @Override
    public double count(int index) {
        return this.background[index];
    }

    @Override
    public double volume() {
        return 1.0;
    }

    public static BackgroundModel fromString(String s) {
        if (s.toLowerCase().equals("wordwise")) {
            return new WordwiseBackground();
        }
        if (s.toLowerCase().equals("uniform")) {
            return Background.uniform();
        }
        List<Double> tokens = InputExtensions.listOfDoubleTokens(s);
        if (tokens.size() == 4) {
            return new Background(tokens);
        }
        if (tokens.size() == 1) {
            return Background.fromGCContent(tokens.get(0));
        }
        throw new IllegalArgumentException("Background string `" + s + "` not recognized.\n" + "It should be either string `wordwise` or monobackground(4 numbers) or GC-content(1 number).\n" + "Numbers should be comma separated, spaces not allowed.\n" + "String you've passed has " + tokens.size() + " numbers");
    }

    public static BackgroundModel uniform() {
        return new Background(new double[]{0.25, 0.25, 0.25, 0.25});
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            if (i != 0) {
                builder.append(',');
            }
            builder.append(this.background[i]);
        }
        return builder.toString();
    }

    @Override
    public boolean is_wordwise() {
        return false;
    }

    @Override
    public double mean_value(double[] values) {
        double result = 0.0;
        for (int letter = 0; letter < 4; ++letter) {
            result += values[letter] * this.probability(letter);
        }
        return result;
    }

    @Override
    public double mean_square_value(double[] values) {
        double mean_square = 0.0;
        for (int letter = 0; letter < 4; ++letter) {
            mean_square += values[letter] * values[letter] * this.probability(letter);
        }
        return mean_square;
    }

    @Override
    public double variance(double[] values) {
        double mean = this.mean_value(values);
        return this.mean_square_value(values) - mean * mean;
    }

    public boolean equals(Object other) {
        if (other instanceof BackgroundModel) {
            boolean result = true;
            for (int i = 0; i < 4; ++i) {
                result = result && this.count(i) == ((BackgroundModel)other).count(i);
            }
            return result;
        }
        return false;
    }

    public static BackgroundModel fromGCContent(double gcContent) {
        double p_at = (1.0 - gcContent) / 2.0;
        double p_cg = gcContent / 2.0;
        return new Background(new double[]{p_at, p_cg, p_cg, p_at});
    }
}

