/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.commons.motifModel.mono;

import ru.autosome.commons.model.Discretizer;
import ru.autosome.commons.motifModel.HasLength;
import ru.autosome.commons.motifModel.MatrixModel;

public class PM
implements MatrixModel,
HasLength {
    public static final int ALPHABET_SIZE = 4;
    protected final double[][] matrix;

    @Override
    public double[][] getMatrix() {
        return this.matrix;
    }

    @Override
    public int alphabetSize() {
        return 4;
    }

    public PM(double[][] matrix) throws IllegalArgumentException {
        for (double[] pos : matrix) {
            if (pos.length == 4) continue;
            throw new IllegalArgumentException("Matrix must have 4 elements in each position");
        }
        this.matrix = matrix;
    }

    @Override
    public int length() {
        return this.matrix.length;
    }

    double[][] discretedMatrix(Discretizer discretizer) {
        double[][] result = new double[this.matrix.length][];
        for (int i = 0; i < this.matrix.length; ++i) {
            result[i] = new double[4];
            for (int j = 0; j < 4; ++j) {
                result[i][j] = discretizer.discrete(this.matrix[i][j]);
            }
        }
        return result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (double[] pos : this.matrix) {
            for (int letter_index = 0; letter_index < this.alphabetSize(); ++letter_index) {
                if (letter_index != 0) {
                    result.append("\t");
                }
                result.append(pos[letter_index]);
            }
            result.append("\n");
        }
        return result.toString();
    }
}

