/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.commons.support;

import gnu.trove.TDoubleCollection;
import gnu.trove.iterator.TDoubleIterator;
import gnu.trove.map.TDoubleDoubleMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ArrayExtensions {
    public static double sum(TDoubleCollection vals) {
        TDoubleIterator iterator = vals.iterator();
        double result = 0.0;
        while (iterator.hasNext()) {
            result += iterator.next();
        }
        return result;
    }

    public static double max(double ... array) throws IllegalArgumentException {
        if (array.length == 0) {
            throw new IllegalArgumentException("Can't calculate maximum of empty array");
        }
        double result = array[0];
        for (double pos : array) {
            result = Math.max(result, pos);
        }
        return result;
    }

    public static double min(double ... array) throws IllegalArgumentException {
        if (array.length == 0) {
            throw new IllegalArgumentException("Can't calculate minimum of empty array");
        }
        double result = array[0];
        for (double pos : array) {
            result = Math.min(result, pos);
        }
        return result;
    }

    public static double sum(double ... array) {
        double result = 0.0;
        for (double el : array) {
            result += el;
        }
        return result;
    }

    public static <T> T[] reverse(T[] array) {
        Object[] result = (Object[])array.clone();
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[array.length - 1 - i];
        }
        return result;
    }

    public static double[] reverse(double[] array) {
        double[] result = (double[])array.clone();
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[array.length - 1 - i];
        }
        return result;
    }

    public static ArrayList<Double> partial_sums(double[] array, double initial) {
        ArrayList<Double> result = new ArrayList<Double>(array.length);
        double sums = initial;
        for (double anArray : array) {
            result.add(sums += anArray);
        }
        return result;
    }

    public static boolean contain(Iterable<String> list, String obj) {
        for (String el : list) {
            if (!el.equals(obj)) continue;
            return true;
        }
        return false;
    }

    public static Integer indexOf(double el, double[] list) {
        for (int i = 0; i < list.length; ++i) {
            if (list[i] != el) continue;
            return i;
        }
        return null;
    }

    public static double[] toPrimitiveArray(Double[] wrappedArray) {
        double[] array = new double[wrappedArray.length];
        for (int i = 0; i < wrappedArray.length; ++i) {
            array[i] = wrappedArray[i];
        }
        return array;
    }

    public static double[] toPrimitiveArray(Collection<Double> wrappedArray) {
        double[] array = new double[wrappedArray.size()];
        int i = 0;
        for (Double element : wrappedArray) {
            array[i] = element;
            ++i;
        }
        return array;
    }

    public static double[][] toPrimitiveArray(List<double[]> wrappedArray) {
        double[][] matrix = new double[wrappedArray.size()][];
        for (int i = 0; i < wrappedArray.size(); ++i) {
            matrix[i] = wrappedArray.get(i);
        }
        return matrix;
    }

    public static int[] indices_of_range(List<Double> list, double value) {
        int ind = Collections.binarySearch(list, value);
        if (ind >= 0) {
            return new int[]{ind, ind};
        }
        int insertion_point = -ind - 1;
        if (insertion_point == 0) {
            return new int[]{-1, -1};
        }
        if (insertion_point < list.size()) {
            return new int[]{insertion_point - 1, insertion_point};
        }
        return new int[]{list.size(), list.size()};
    }

    public static double[] descending_sorted_hash_keys(TDoubleDoubleMap hsh) {
        double[] keys = hsh.keys();
        Arrays.sort(keys);
        return ArrayExtensions.reverse(keys);
    }
}

