/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.macroape.calculation.generalized;

import java.util.ArrayList;
import java.util.List;
import ru.autosome.ape.model.exception.HashOverflowException;
import ru.autosome.commons.backgroundModel.GeneralizedBackgroundModel;
import ru.autosome.commons.cli.ResultInfo;
import ru.autosome.commons.model.Discretizer;
import ru.autosome.commons.model.Orientation;
import ru.autosome.commons.model.Position;
import ru.autosome.commons.motifModel.Alignable;
import ru.autosome.commons.motifModel.Discretable;
import ru.autosome.macroape.calculation.generalized.AlignedModelIntersection;
import ru.autosome.macroape.model.PairAligned;

public abstract class CompareModelsCountsGiven<ModelType extends Alignable<ModelType> & Discretable<ModelType>, BackgroundType extends GeneralizedBackgroundModel> {
    public final ModelType firstPWM;
    public final ModelType secondPWM;
    public final BackgroundType firstBackground;
    public final BackgroundType secondBackground;
    public final Discretizer discretizer;
    public final Integer maxPairHashSize;

    public CompareModelsCountsGiven(ModelType firstPWM, ModelType secondPWM, BackgroundType firstBackground, BackgroundType secondBackground, Discretizer discretizer, Integer maxPairHashSize) {
        this.firstPWM = (Alignable)((Discretable)firstPWM).discrete(discretizer);
        this.secondPWM = (Alignable)((Discretable)secondPWM).discrete(discretizer);
        this.firstBackground = firstBackground;
        this.secondBackground = secondBackground;
        this.maxPairHashSize = maxPairHashSize;
        this.discretizer = discretizer;
    }

    private List<Position> relative_alignments() {
        ArrayList<Position> result = new ArrayList<Position>();
        for (int shift = -this.secondPWM.length(); shift <= this.firstPWM.length(); ++shift) {
            result.add(new Position(shift, Orientation.direct));
            result.add(new Position(shift, Orientation.revcomp));
        }
        return result;
    }

    protected double firstCountRenormMultiplier(PairAligned alignment) {
        return Math.pow(this.firstBackground.volume(), alignment.length() - this.firstPWM.length());
    }

    protected double secondCountRenormMultiplier(PairAligned alignment) {
        return Math.pow(this.secondBackground.volume(), alignment.length() - this.secondPWM.length());
    }

    public SimilarityInfo<ModelType> jaccard(double thresholdFirst, double thresholdSecond, double firstCount, double secondCount) throws HashOverflowException {
        double bestSimilarity = -1.0;
        SimilarityInfo<ModelType> bestSimilarityInfo = null;
        for (Position position : this.relative_alignments()) {
            SimilarityInfo<ModelType> similarityInfo = this.jaccardAtPosition(thresholdFirst, thresholdSecond, firstCount, secondCount, position);
            double similarity = similarityInfo.similarity();
            if (!(similarity > bestSimilarity)) continue;
            bestSimilarity = similarity;
            bestSimilarityInfo = similarityInfo;
        }
        return bestSimilarityInfo;
    }

    public SimilarityInfo<ModelType> jaccardAtPosition(double thresholdFirst, double thresholdSecond, double firstCount, double secondCount, Position position) throws HashOverflowException {
        PairAligned<ModelType> alignment = new PairAligned<ModelType>(this.firstPWM, this.secondPWM, position);
        double intersection = this.calculator(alignment).count_in_intersection(this.discretizer.upscale(thresholdFirst), this.discretizer.upscale(thresholdSecond));
        double firstCountRenormed = firstCount * this.firstCountRenormMultiplier(alignment);
        double secondCountRenormed = secondCount * this.secondCountRenormMultiplier(alignment);
        return new SimilarityInfo<ModelType>(alignment, intersection, firstCountRenormed, secondCountRenormed);
    }

    protected abstract AlignedModelIntersection<ModelType, BackgroundType> calculator(PairAligned<ModelType> var1);

    public static class SimilarityInfo<ModelType extends Alignable<ModelType>>
    extends ResultInfo {
        public final PairAligned<ModelType> alignment;
        public final double recognizedByBoth;
        public final double recognizedByFirst;
        public final double recognizedBySecond;

        public SimilarityInfo(PairAligned<ModelType> alignment, double recognizedByBoth, double recognizedByFirst, double recognizedBySecond) {
            this.recognizedByFirst = recognizedByFirst;
            this.recognizedBySecond = recognizedBySecond;
            this.recognizedByBoth = recognizedByBoth;
            this.alignment = alignment;
        }

        public Double realPvalueFirst(GeneralizedBackgroundModel background) {
            double vocabularyVolume = Math.pow(background.volume(), this.alignment.length());
            return this.recognizedByFirst / vocabularyVolume;
        }

        public Double realPvalueSecond(GeneralizedBackgroundModel background) {
            double vocabularyVolume = Math.pow(background.volume(), this.alignment.length());
            return this.recognizedBySecond / vocabularyVolume;
        }

        public int shift() {
            return this.alignment.shift();
        }

        public Orientation orientation() {
            return this.alignment.orientation();
        }

        public int overlap() {
            return this.alignment.overlapSize();
        }

        public static Double jaccardByCounts(double recognizedByFirst, double recognizedBySecond, double recognizedByBoth) {
            if (recognizedByFirst == 0.0 || recognizedBySecond == 0.0) {
                return null;
            }
            double union = recognizedByFirst + recognizedBySecond - recognizedByBoth;
            return recognizedByBoth / union;
        }

        public Double similarity() {
            return SimilarityInfo.jaccardByCounts(this.recognizedByFirst, this.recognizedBySecond, this.recognizedByBoth);
        }

        public Double distance() {
            Double similarity = this.similarity();
            if (similarity == null) {
                return null;
            }
            return 1.0 - similarity;
        }
    }
}

