/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.macroape.calculation.generalized;

import java.util.ArrayList;
import java.util.List;
import ru.autosome.ape.calculation.findPvalue.CanFindPvalue;
import ru.autosome.ape.calculation.findPvalue.FindPvalueAPE;
import ru.autosome.ape.calculation.findThreshold.FindThresholdAPE;
import ru.autosome.ape.model.exception.HashOverflowException;
import ru.autosome.commons.backgroundModel.GeneralizedBackgroundModel;
import ru.autosome.commons.model.BoundaryType;
import ru.autosome.commons.model.Discretizer;
import ru.autosome.commons.motifModel.Alignable;
import ru.autosome.commons.motifModel.Discretable;
import ru.autosome.macroape.calculation.generalized.CompareModels;
import ru.autosome.macroape.calculation.generalized.CompareModelsCountsGiven;
import ru.autosome.macroape.cli.generalized.ScanCollection;
import ru.autosome.macroape.model.PairAligned;

public abstract class ScanCollection<ModelType extends Alignable<ModelType> & Discretable<ModelType>, BackgroundType extends GeneralizedBackgroundModel> {
    protected final List<ScanCollection.ThresholdEvaluator> thresholdEvaluators;
    public final ModelType queryPWM;
    public double pvalue;
    public Double queryPredefinedThreshold;
    public Discretizer roughDiscretizer;
    public Discretizer preciseDiscretizer;
    public BackgroundType queryBackground;
    public BackgroundType collectionBackground;
    public BoundaryType pvalueBoundaryType;
    public Integer maxHashSize;
    public Integer maxPairHashSize;
    public Double similarityCutoff;
    public Double preciseRecalculationCutoff;

    public ScanCollection(List<ScanCollection.ThresholdEvaluator> thresholdEvaluators, ModelType queryPWM) {
        this.thresholdEvaluators = thresholdEvaluators;
        this.queryPWM = queryPWM;
    }

    protected abstract CompareModels<ModelType, BackgroundType> calculation(ModelType var1, ModelType var2, BackgroundType var3, BackgroundType var4, CanFindPvalue var5, CanFindPvalue var6, Discretizer var7, Integer var8);

    public List<SimilarityInfo> similarityInfos() throws HashOverflowException {
        ArrayList<SimilarityInfo> result = new ArrayList<SimilarityInfo>(this.thresholdEvaluators.size());
        FindPvalueAPE<ModelType, BackgroundType> roughQueryPvalueEvaluator = new FindPvalueAPE<ModelType, BackgroundType>(this.queryPWM, this.queryBackground, this.roughDiscretizer, this.maxHashSize);
        FindPvalueAPE<ModelType, BackgroundType> preciseQueryPvalueEvaluator = new FindPvalueAPE<ModelType, BackgroundType>(this.queryPWM, this.queryBackground, this.preciseDiscretizer, this.maxHashSize);
        double roughQueryThreshold = this.queryThreshold(this.roughDiscretizer);
        double preciseQueryThreshold = this.queryThreshold(this.preciseDiscretizer);
        for (ScanCollection.ThresholdEvaluator knownMotifEvaluator : this.thresholdEvaluators) {
            boolean precise = false;
            CompareModels<Alignable, BackgroundType> roughCalculation = this.calculation(this.queryPWM, (Alignable)knownMotifEvaluator.pwm, this.queryBackground, this.collectionBackground, roughQueryPvalueEvaluator, knownMotifEvaluator.roughPvalueCalculator, this.roughDiscretizer, this.maxPairHashSize);
            Double roughCollectionThreshold = knownMotifEvaluator.roughThresholdCalculator.thresholdByPvalue((double)this.pvalue, (BoundaryType)this.pvalueBoundaryType).threshold;
            CompareModelsCountsGiven.SimilarityInfo<Alignable> info = roughCalculation.jaccard(roughQueryThreshold, roughCollectionThreshold);
            if (this.preciseRecalculationCutoff != null && info.similarity() >= this.preciseRecalculationCutoff && knownMotifEvaluator.preciseThresholdCalculator != null) {
                CompareModels<Alignable, BackgroundType> preciseCalculation = this.calculation(this.queryPWM, (Alignable)knownMotifEvaluator.pwm, this.queryBackground, this.collectionBackground, preciseQueryPvalueEvaluator, knownMotifEvaluator.precisePvalueCalculator, this.preciseDiscretizer, this.maxPairHashSize);
                Double preciseCollectionThreshold = knownMotifEvaluator.preciseThresholdCalculator.thresholdByPvalue((double)this.pvalue, (BoundaryType)this.pvalueBoundaryType).threshold;
                info = preciseCalculation.jaccard(preciseQueryThreshold, preciseCollectionThreshold);
                precise = true;
            }
            if (this.similarityCutoff != null && !(info.similarity() >= this.similarityCutoff)) continue;
            result.add(new SimilarityInfo(this, (Alignable)knownMotifEvaluator.pwm, knownMotifEvaluator.name, info, precise));
        }
        return result;
    }

    double queryThreshold(Discretizer discretizer) throws HashOverflowException {
        if (this.queryPredefinedThreshold != null) {
            return this.queryPredefinedThreshold;
        }
        FindThresholdAPE<Discretable, BackgroundType> pvalue_calculator = new FindThresholdAPE<Discretable, BackgroundType>((Discretable)this.queryPWM, this.queryBackground, discretizer, this.maxHashSize);
        return pvalue_calculator.thresholdByPvalue((double)this.pvalue, (BoundaryType)this.pvalueBoundaryType).threshold;
    }

    public class SimilarityInfo
    extends CompareModelsCountsGiven.SimilarityInfo<ModelType> {
        public final ModelType collectionPWM;
        public final String name;
        public final boolean precise;
        final /* synthetic */ ScanCollection this$0;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        public SimilarityInfo(ModelType ModelType, String recognizedBySecond, PairAligned<ModelType> pairAligned, double precise, double d, double d2, boolean bl) {
            void collectionPWM;
            void alignment;
            this.this$0 = (ScanCollection)this$0;
            super(alignment, recognizedByBoth, recognizedByFirst, (double)recognizedBySecond);
            this.collectionPWM = collectionPWM;
            this.name = (String)name;
            this.precise = precise;
        }

        /*
         * WARNING - Possible parameter corruption
         */
        public SimilarityInfo(ModelType collectionPWM, String name, CompareModelsCountsGiven.SimilarityInfo<ModelType> similarityInfo, boolean precise) {
            this.this$0 = (ScanCollection)this$0;
            super(similarityInfo.alignment, similarityInfo.recognizedByBoth, similarityInfo.recognizedByFirst, similarityInfo.recognizedBySecond);
            this.collectionPWM = collectionPWM;
            this.name = name;
            this.precise = precise;
        }
    }
}

