/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.macroape.cli.generalized;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import ru.autosome.ape.calculation.findThreshold.CanFindThreshold;
import ru.autosome.ape.calculation.findThreshold.FindThresholdAPE;
import ru.autosome.ape.model.exception.HashOverflowException;
import ru.autosome.commons.backgroundModel.GeneralizedBackgroundModel;
import ru.autosome.commons.model.BoundaryType;
import ru.autosome.commons.model.Discretizer;
import ru.autosome.commons.model.Named;
import ru.autosome.commons.model.PseudocountCalculator;
import ru.autosome.commons.motifModel.Discretable;
import ru.autosome.commons.motifModel.HasLength;
import ru.autosome.commons.motifModel.ScoreDistribution;
import ru.autosome.commons.motifModel.types.DataModel;
import ru.autosome.macroape.calculation.generalized.CompareModelsCountsGiven;

public abstract class CollectDistanceMatrix<ModelType extends Discretable<ModelType> & ScoreDistribution<BackgroundType>, BackgroundType extends GeneralizedBackgroundModel> {
    protected Discretizer roughDiscretizer;
    protected Discretizer preciseDiscretizer;
    protected File pathToCollectionOfPWMs;
    protected BackgroundType background;
    protected DataModel dataModel;
    protected Integer maxHashSize;
    protected Integer maxPairHashSize;
    protected double effectiveCount;
    protected PseudocountCalculator pseudocount;
    protected BoundaryType pvalueBoundary;
    protected double pvalue;
    protected Double preciseRecalculationCutoff;
    protected boolean transpose;
    protected int numOfThreads;
    protected int numThread;
    protected List<Named<ModelType>> pwmCollection;

    protected abstract String DOC_background_option();

    protected abstract String DOC_run_string();

    protected String documentString() {
        return "Command-line format:\n" + this.DOC_run_string() + " <folder with PWMs> [options]\n" + "\n" + "Options:\n" + "  [--rough-discretization <discretization level>] or [-d]\n" + "  [--precise-discretization <discretization level>]\n" + "  [--precise [<level>]] minimal similarity to check on the second pass in precise mode, off by default, '--precise 0.01' if level is not set\n" + "  [--pvalue <P-value>] or [-p]\n" + "  [--boundary lower|upper] Upper boundary (default) means that the obtained P-value is greater than or equal to the requested P-value\n" + "  [--pcm] - treat the input file as Position Count Matrix. PCM-to-PWM transformation to be done internally.\n" + "  [--ppm] or [--pfm] - treat the input file as Position Frequency Matrix. PPM-to-PWM transformation to be done internally.\n" + "  [--effective-count <count>] - effective samples set size for PPM-to-PWM conversion (default: 100). \n" + "  [--background <background probabilities>] or [-b] " + this.DOC_background_option() + "\n" + "  [--transpose] - load motif from transposed matrix (nucleotides in lines).\n" + "  [--parallelize <num of threads> <thread number>] - run only one task per numOfThreads (those equal to thread number modulo numOfThreads)\n" + this.DOC_additional_options() + "\n" + "Examples:\n" + "  " + this.DOC_run_string() + " ./motifs/ -d 10\n";
    }

    protected String DOC_additional_options() {
        return "";
    }

    protected void setup_from_arglist(List<String> argv) {
        this.extract_path_to_collection_of_pwms(argv);
        while (argv.size() > 0) {
            this.extract_option(argv);
        }
        this.pwmCollection = this.loadMotifCollection(this.pathToCollectionOfPWMs);
    }

    protected abstract List<Named<ModelType>> loadMotifCollection(File var1);

    protected abstract void initialize_default_background();

    protected void initialize_defaults() {
        this.initialize_default_background();
        this.roughDiscretizer = new Discretizer(1.0);
        this.preciseDiscretizer = new Discretizer(10.0);
        this.maxHashSize = 10000000;
        this.maxPairHashSize = 10000;
        this.dataModel = DataModel.PWM;
        this.effectiveCount = 100.0;
        this.pseudocount = PseudocountCalculator.logPseudocount;
        this.pvalue = 5.0E-4;
        this.pvalueBoundary = BoundaryType.UPPER;
        this.preciseRecalculationCutoff = null;
        this.transpose = false;
        this.numOfThreads = 1;
        this.numThread = 0;
        this.pathToCollectionOfPWMs = null;
        this.pwmCollection = null;
    }

    protected void extract_option(List<String> argv) {
        String opt = argv.remove(0);
        if (opt.equals("-b") || opt.equals("--background")) {
            this.background = this.extract_background(argv.remove(0));
        } else if (opt.equals("-p") || opt.equals("--pvalue")) {
            this.pvalue = Double.valueOf(argv.remove(0));
        } else if (opt.equals("--max-hash-size")) {
            this.maxHashSize = Integer.valueOf(argv.remove(0));
        } else if (opt.equals("--max-2d-hash-size")) {
            this.maxPairHashSize = Integer.valueOf(argv.remove(0));
        } else if (opt.equals("--rough-discretization") || opt.equals("-d") || opt.equals("--discretization")) {
            this.roughDiscretizer = Discretizer.fromString(argv.remove(0));
        } else if (opt.equals("--precise-discretization")) {
            this.preciseDiscretizer = Discretizer.fromString(argv.remove(0));
        } else if (opt.equals("--pcm")) {
            this.dataModel = DataModel.PCM;
        } else if (opt.equals("--ppm") || opt.equals("--pfm")) {
            this.dataModel = DataModel.PPM;
        } else if (opt.equals("--effective-count")) {
            this.effectiveCount = Double.valueOf(argv.remove(0));
        } else if (opt.equals("--pseudocount")) {
            this.pseudocount = PseudocountCalculator.fromString(argv.remove(0));
        } else if (opt.equals("--boundary")) {
            this.pvalueBoundary = BoundaryType.valueOf(argv.remove(0).toUpperCase());
        } else if (opt.equals("--precise")) {
            this.preciseRecalculationCutoff = Double.valueOf(argv.remove(0));
        } else if (opt.equals("--parallelize")) {
            this.numOfThreads = Integer.valueOf(argv.remove(0));
            this.numThread = Integer.valueOf(argv.remove(0));
        } else if (opt.equals("--transpose")) {
            this.transpose = true;
        } else if (this.failed_to_recognize_additional_options(opt, argv)) {
            throw new IllegalArgumentException("Unknown option '" + opt + "'");
        }
    }

    protected boolean failed_to_recognize_additional_options(String opt, List<String> argv) {
        return true;
    }

    protected void extract_path_to_collection_of_pwms(List<String> argv) {
        try {
            this.pathToCollectionOfPWMs = new File(argv.remove(0));
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Specify PWM-collection folder", e);
        }
    }

    protected List<PWMWithThreshold> collectThreshold() throws HashOverflowException {
        ArrayList<PWMWithThreshold> result = new ArrayList<PWMWithThreshold>();
        for (Named<ModelType> pwm : this.pwmCollection) {
            FindThresholdAPE<Discretable, BackgroundType> roughThresholdCalculator = new FindThresholdAPE<Discretable, BackgroundType>((Discretable)pwm.getObject(), this.background, this.roughDiscretizer, this.maxHashSize);
            CanFindThreshold.ThresholdInfo roughThresholdInfo = roughThresholdCalculator.thresholdByPvalue(this.pvalue, this.pvalueBoundary);
            double roughThreshold = roughThresholdInfo.threshold;
            double roughCount = roughThresholdInfo.numberOfRecognizedWords((GeneralizedBackgroundModel)this.background, ((HasLength)((Object)((Discretable)pwm.getObject()))).length());
            FindThresholdAPE<Discretable, BackgroundType> preciseThresholdCalculator = new FindThresholdAPE<Discretable, BackgroundType>((Discretable)pwm.getObject(), this.background, this.preciseDiscretizer, this.maxHashSize);
            CanFindThreshold.ThresholdInfo preciseThresholdInfo = preciseThresholdCalculator.thresholdByPvalue(this.pvalue, this.pvalueBoundary);
            double preciseThreshold = preciseThresholdInfo.threshold;
            double preciseCount = preciseThresholdInfo.numberOfRecognizedWords((GeneralizedBackgroundModel)this.background, ((HasLength)((Object)((Discretable)pwm.getObject()))).length());
            result.add(new PWMWithThreshold(pwm, roughThreshold, roughCount, preciseThreshold, preciseCount));
        }
        return result;
    }

    protected double calculateDistance(PWMWithThreshold first, PWMWithThreshold second) throws HashOverflowException {
        CompareModelsCountsGiven<Discretable, BackgroundType> calc = this.calculator((Discretable)first.pwm.getObject(), (Discretable)second.pwm.getObject());
        CompareModelsCountsGiven.SimilarityInfo<Discretable> info = calc.jaccard(first.roughThreshold, second.roughThreshold, first.roughCount, second.roughCount);
        if (this.preciseRecalculationCutoff != null && info.similarity() > this.preciseRecalculationCutoff) {
            calc = this.calculator((Discretable)first.pwm.getObject(), (Discretable)second.pwm.getObject());
            info = calc.jaccard(first.preciseThreshold, second.preciseThreshold, first.preciseCount, second.preciseCount);
        }
        return info.distance();
    }

    public void process() throws HashOverflowException {
        int taskNum = 0;
        List<PWMWithThreshold> thresholds = this.collectThreshold();
        Collections.sort(thresholds, new Comparator<PWMWithThreshold>(){

            @Override
            public int compare(PWMWithThreshold o1, PWMWithThreshold o2) {
                return o1.pwm.getName().compareTo(o2.pwm.getName());
            }
        });
        System.out.print("Motif name\t");
        for (PWMWithThreshold second : thresholds) {
            System.out.print(second.pwm.getName() + "\t");
        }
        System.out.println();
        for (PWMWithThreshold first : thresholds) {
            System.out.print(first.pwm.getName() + "\t");
            for (PWMWithThreshold second : thresholds) {
                if (taskNum % this.numOfThreads == this.numThread % this.numOfThreads) {
                    int cmp = first.pwm.getName().compareTo(second.pwm.getName());
                    if (cmp == 0) {
                        System.out.print("0.0\t");
                    } else if (cmp < 0) {
                        System.out.print("x\t");
                    } else {
                        double distance = this.calculateDistance(first, second);
                        System.out.print(distance + "\t");
                    }
                } else {
                    System.out.print("x\t");
                }
                ++taskNum;
            }
            System.out.println();
            System.err.print(".");
        }
    }

    protected abstract CompareModelsCountsGiven<ModelType, BackgroundType> calculator(ModelType var1, ModelType var2);

    protected abstract BackgroundType extract_background(String var1);

    class PWMWithThreshold {
        final Named<ModelType> pwm;
        final double roughThreshold;
        final double roughCount;
        final double preciseThreshold;
        final double preciseCount;

        PWMWithThreshold(Named<ModelType> pwm, double roughThreshold, double roughCount, double preciseThreshold, double preciseCount) {
            this.pwm = pwm;
            this.roughThreshold = roughThreshold;
            this.roughCount = roughCount;
            this.preciseThreshold = preciseThreshold;
            this.preciseCount = preciseCount;
        }
    }
}

