/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.perfectosape.calculation.ScoringModelDistributions;

import gnu.trove.iterator.TDoubleDoubleIterator;
import gnu.trove.map.TDoubleDoubleMap;
import gnu.trove.map.hash.TDoubleDoubleHashMap;
import ru.autosome.ape.calculation.findThreshold.CanFindThresholdApproximation;
import ru.autosome.ape.calculation.findThreshold.GaussianThresholdEstimator;
import ru.autosome.ape.model.ScoreDistributionTop;
import ru.autosome.ape.model.exception.HashOverflowException;
import ru.autosome.commons.backgroundModel.mono.BackgroundModel;
import ru.autosome.commons.motifModel.mono.PWM;
import ru.autosome.commons.scoringModel.PWMOnBackground;
import ru.autosome.perfectosape.calculation.ScoringModelDistributions.ScoringModelDistributions;

public class CountingPWM
extends ScoringModelDistributions {
    private final Integer maxHashSize;
    final PWM pwm;
    final BackgroundModel background;

    public CountingPWM(PWM pwm, BackgroundModel background, Integer maxHashSize) {
        this.pwm = pwm;
        this.background = background;
        this.maxHashSize = maxHashSize;
    }

    @Override
    CanFindThresholdApproximation gaussianThresholdEstimator() {
        return new GaussianThresholdEstimator<PWMOnBackground>(this.pwm.onBackground(this.background));
    }

    protected TDoubleDoubleMap initialCountDistribution() {
        TDoubleDoubleHashMap scores = new TDoubleDoubleHashMap();
        scores.put(0.0, 1.0);
        return scores;
    }

    @Override
    protected ScoreDistributionTop score_distribution_above_threshold(double threshold) throws HashOverflowException {
        TDoubleDoubleMap scores = this.initialCountDistribution();
        for (int pos = 0; pos < this.pwm.length(); ++pos) {
            if (!this.exceedHashSizeLimit(scores = this.recalc_score_hash(scores, this.pwm.getMatrix()[pos], threshold - this.pwm.best_suffix(pos + 1)))) continue;
            throw new HashOverflowException("Hash overflow in PWM::ThresholdByPvalue#score_distribution_above_threshold");
        }
        ScoreDistributionTop result = new ScoreDistributionTop(scores, this.vocabularyVolume(), threshold);
        result.setWorstScore(this.pwm.worst_score());
        result.setBestScore(this.pwm.best_score());
        return result;
    }

    private TDoubleDoubleMap recalc_score_hash(TDoubleDoubleMap scores, double[] column, double least_sufficient) {
        TDoubleDoubleHashMap new_scores = new TDoubleDoubleHashMap(scores.size());
        TDoubleDoubleIterator iterator = scores.iterator();
        while (iterator.hasNext()) {
            iterator.advance();
            double score = iterator.key();
            double count = iterator.value();
            for (int letter = 0; letter < 4; ++letter) {
                double new_score = score + column[letter];
                if (!(new_score >= least_sufficient)) continue;
                double add = count * this.background.count(letter);
                new_scores.adjustOrPutValue(new_score, add, add);
            }
        }
        return new_scores;
    }

    private double vocabularyVolume() {
        return Math.pow(this.background.volume(), this.pwm.length());
    }

    private boolean exceedHashSizeLimit(TDoubleDoubleMap scores) {
        return this.maxHashSize != null && scores.size() > this.maxHashSize;
    }
}

