/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.perfectosape.calculation;

import ru.autosome.ape.calculation.findPvalue.CanFindPvalue;
import ru.autosome.ape.model.exception.HashOverflowException;
import ru.autosome.commons.model.Position;
import ru.autosome.commons.model.PositionInterval;
import ru.autosome.commons.motifModel.Encodable;
import ru.autosome.commons.motifModel.HasLength;
import ru.autosome.commons.motifModel.ScoringModel;
import ru.autosome.perfectosape.calculation.EstimateAffinityMinPvalue;
import ru.autosome.perfectosape.model.Sequence;
import ru.autosome.perfectosape.model.SequenceWithSNP;
import ru.autosome.perfectosape.model.encoded.EncodedSequenceType;
import ru.autosome.perfectosape.model.encoded.EncodedSequenceWithSNVType;

public class SingleSNPScan<SequenceType extends EncodedSequenceType, SequenceWithSNVType extends EncodedSequenceWithSNVType<SequenceType>, ModelType extends ScoringModel<SequenceType> & Encodable<SequenceType, SequenceWithSNVType>> {
    final ModelType pwm;
    final SequenceWithSNP sequenceWithSNP;
    final SequenceWithSNVType encodedSequenceWithSNP;
    final CanFindPvalue pvalueCalculator;
    final int expandRegionLength;

    public SingleSNPScan(ModelType pwm, SequenceWithSNP sequenceWithSNP, SequenceWithSNVType encodedSequenceWithSNP, CanFindPvalue pvalueCalculator, int expandRegionLength) {
        if (sequenceWithSNP.length() < pwm.length()) {
            throw new IllegalArgumentException("Can't scan sequence '" + sequenceWithSNP + "' (length " + sequenceWithSNP.length() + ") with motif of length " + pwm.length());
        }
        this.pwm = pwm;
        this.sequenceWithSNP = sequenceWithSNP;
        this.encodedSequenceWithSNP = encodedSequenceWithSNP;
        this.pvalueCalculator = pvalueCalculator;
        this.expandRegionLength = expandRegionLength;
        if (sequenceWithSNP.num_cases() != 2) {
            throw new IllegalArgumentException("Unable to process more than two variants of nucleotide for SNP " + sequenceWithSNP);
        }
    }

    public SingleSNPScan(ModelType pwm, SequenceWithSNP sequenceWithSNP, CanFindPvalue pvalueCalculator, int expandRegionLength) {
        if (sequenceWithSNP.length() < pwm.length()) {
            throw new IllegalArgumentException("Can't scan sequence '" + sequenceWithSNP + "' (length " + sequenceWithSNP.length() + ") with motif of length " + pwm.length());
        }
        this.pwm = pwm;
        this.sequenceWithSNP = sequenceWithSNP;
        this.encodedSequenceWithSNP = (EncodedSequenceWithSNVType)((Encodable)pwm).encodeSequenceWithSNP(sequenceWithSNP);
        this.pvalueCalculator = pvalueCalculator;
        this.expandRegionLength = expandRegionLength;
        if (sequenceWithSNP.num_cases() != 2) {
            throw new IllegalArgumentException("Unable to process more than two variants of nucleotide for SNP " + sequenceWithSNP);
        }
    }

    PositionInterval positionsToCheck() {
        return this.sequenceWithSNP.positionsOverlappingSNV(this.pwm.length()).expand(this.expandRegionLength);
    }

    public RegionAffinityVariantInfo affinityVariantInfo(int allele_number) throws HashOverflowException {
        EstimateAffinityMinPvalue<HasLength, ModelType> affinity_calculator = new EstimateAffinityMinPvalue<HasLength, ModelType>(this.pwm, (HasLength)this.encodedSequenceWithSNP.sequenceVariant(allele_number), this.pvalueCalculator, this.positionsToCheck());
        Position pos = affinity_calculator.bestPosition();
        Position pos_centered = new Position(pos.position() - this.sequenceWithSNP.left.length(), pos.orientation());
        double pvalue = affinity_calculator.affinity();
        Character allele = Character.valueOf(this.sequenceWithSNP.mid[allele_number]);
        Sequence sequence = this.sequenceWithSNP.sequence_variants()[allele_number];
        Sequence word = sequence.substring(pos, this.pwm.length());
        return new RegionAffinityVariantInfo(pos_centered, allele, pvalue, word);
    }

    public RegionAffinityInfos affinityInfos() throws HashOverflowException {
        return new RegionAffinityInfos(this.affinityVariantInfo(0), this.affinityVariantInfo(1));
    }

    public static class RegionAffinityInfos {
        final RegionAffinityVariantInfo info_1;
        final RegionAffinityVariantInfo info_2;

        public RegionAffinityVariantInfo getInfo_1() {
            return this.info_1;
        }

        public RegionAffinityVariantInfo getInfo_2() {
            return this.info_2;
        }

        RegionAffinityInfos(RegionAffinityVariantInfo info_1, RegionAffinityVariantInfo info_2) {
            this.info_1 = info_1;
            this.info_2 = info_2;
        }

        public double foldChange() {
            return this.info_1.pvalue / this.info_2.pvalue;
        }

        public double logFoldChange() {
            return Math.log(this.info_1.pvalue / this.info_2.pvalue) / Math.log(2.0);
        }

        public String toString() {
            return this.toString(false);
        }

        public String toString(boolean useLogFoldChange) {
            StringBuilder result = new StringBuilder();
            result.append(this.info_1.position.toString()).append("\t").append(this.info_1.word).append("\t");
            result.append(this.info_2.position.toString()).append("\t").append(this.info_2.word).append("\t");
            result.append(this.info_1.allele).append("/").append(this.info_2.allele).append("\t");
            result.append(this.info_1.pvalue).append("\t").append(this.info_2.pvalue).append("\t");
            if (useLogFoldChange) {
                result.append(this.logFoldChange());
            } else {
                result.append(this.foldChange());
            }
            return result.toString();
        }

        public String toStringShort() {
            StringBuilder result = new StringBuilder();
            result.append(String.format("%.2e", this.info_1.pvalue)).append("\t");
            result.append(String.format("%.2e", this.info_2.pvalue)).append("\t");
            result.append(this.info_1.position.toStringShort()).append("\t");
            result.append(this.info_2.position.toStringShort());
            return result.toString();
        }
    }

    public static class RegionAffinityVariantInfo {
        final Position position;
        final Sequence word;
        final Character allele;
        final double pvalue;

        public Position getPosition() {
            return this.position;
        }

        public Sequence getWord() {
            return this.word;
        }

        public Character getAllele() {
            return this.allele;
        }

        public double getPvalue() {
            return this.pvalue;
        }

        RegionAffinityVariantInfo(Position position, Character allele, double pvalue, Sequence word) {
            this.position = position;
            this.allele = allele;
            this.pvalue = pvalue;
            this.word = word;
        }
    }
}

