/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.perfectosape.example;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import ru.autosome.ape.calculation.PrecalculateThresholdList;
import ru.autosome.ape.calculation.findPvalue.CanFindPvalue;
import ru.autosome.ape.calculation.findPvalue.FindPvalueBsearch;
import ru.autosome.ape.model.exception.HashOverflowException;
import ru.autosome.commons.backgroundModel.mono.WordwiseBackground;
import ru.autosome.commons.importer.PWMImporter;
import ru.autosome.commons.model.BoundaryType;
import ru.autosome.commons.model.Discretizer;
import ru.autosome.commons.model.Named;
import ru.autosome.commons.model.PseudocountCalculator;
import ru.autosome.commons.motifModel.Discretable;
import ru.autosome.commons.motifModel.mono.PPM;
import ru.autosome.commons.motifModel.mono.PWM;
import ru.autosome.commons.scoringModel.PWMOnBackground;
import ru.autosome.perfectosape.calculation.SingleSNPScan;
import ru.autosome.perfectosape.model.SequenceWithSNP;

public class MultiSNPScan {
    public static void main(String[] args) throws HashOverflowException {
        double[] pvalues = PrecalculateThresholdList.PVALUE_LIST;
        Discretizer discretizer = new Discretizer(10000.0);
        WordwiseBackground background = new WordwiseBackground();
        BoundaryType pvalue_boundary = BoundaryType.LOWER;
        Integer max_hash_size = null;
        double ppm_effective_count = 100.0;
        ArrayList<Named<Object>> pwmCollection = new ArrayList<Named<Object>>();
        pwmCollection.add(new PWMImporter().loadMotifWithName("test_data/pwm/KLF4_f2.pwm"));
        pwmCollection.add(new PWMImporter().loadMotifWithName("test_data/pwm/SP1_f1.pwm"));
        double[][] matrix_cAVNCT = new double[][]{{1.0, 2.0, 1.0, 1.0}, {10.5, -3.0, 0.0, 0.0}, {5.0, 5.0, 5.0, -10.0}, {0.0, 0.0, 0.0, 0.0}, {-1.0, 10.5, -1.0, 0.0}, {0.0, 0.0, 0.0, 2.0}};
        Named<PWM> pwm_manual_constructed = new Named<PWM>(new PWM(matrix_cAVNCT), "PWM for cAVNCt consensus sequence (name of PWM)");
        pwmCollection.add(pwm_manual_constructed);
        double[][] ppm_matrix = new double[][]{{0.2, 0.4, 0.2, 0.2}, {0.9, 0.0, 0.05, 0.05}, {0.3, 0.3, 0.3, 0.1}, {0.25, 0.25, 0.25, 0.25}, {0.0, 0.9, 0.0, 0.1}, {0.2, 0.2, 0.2, 0.4}};
        Named<PPM> ppm = new Named<PPM>(new PPM(ppm_matrix), "cAVNCt PPM (slightly different from another cAVNCt matrix)");
        Named<PWM> pwm_from_ppm = new Named<PWM>(ppm.getObject().to_pwm(background, ppm_effective_count, PseudocountCalculator.logPseudocount), ppm.getName());
        pwmCollection.add(pwm_from_ppm);
        ArrayList<SequenceWithSNP> snpCollection = new ArrayList<SequenceWithSNP>();
        snpCollection.add(SequenceWithSNP.fromString("AAGGTCAATACTCAACATCATAAAAACAGACAAAAGTATAAAACTTACAG[C/G]GTCTTACAAAAAGGATGATCCAGTAATATGCTGCTTACAAGAAACCCACC"));
        snpCollection.add(new SequenceWithSNP("AGGGAAACAAAAATTGTTCGGAAAGGAGAACTAAGATGTATGAATGTTTC", new char[]{'G', 'T'}, "TTTTTAAGTGAAAAGTGTATAGTTCAGAGTGTAATATTTATTACCAGTAT"));
        HashMap<String, FindPvalueBsearch> pwmCollectionWithPvalueCalculators = new HashMap<String, FindPvalueBsearch>();
        HashMap pwmCollectionByName = new HashMap();
        PrecalculateThresholdList<Discretable, WordwiseBackground> listCalculator = new PrecalculateThresholdList<Discretable, WordwiseBackground>(pvalues, discretizer, background, pvalue_boundary, max_hash_size);
        for (Named named : pwmCollection) {
            FindPvalueBsearch findPvalue = new FindPvalueBsearch(listCalculator.bsearch_list_for_pwm((Discretable)named.getObject()));
            pwmCollectionWithPvalueCalculators.put(named.getName(), findPvalue);
            pwmCollectionByName.put(named.getName(), named.getObject());
        }
        HashMap results = new HashMap();
        for (String pwmName : pwmCollectionWithPvalueCalculators.keySet()) {
            PWM pwm = (PWM)pwmCollectionByName.get(pwmName);
            CanFindPvalue pvalueCalculator = (CanFindPvalue)pwmCollectionWithPvalueCalculators.get(pwm);
            HashMap<SequenceWithSNP, SingleSNPScan.RegionAffinityInfos> result_part = new HashMap<SequenceWithSNP, SingleSNPScan.RegionAffinityInfos>();
            for (SequenceWithSNP sequenceWithSNP : snpCollection) {
                if (sequenceWithSNP.length() >= pwm.length()) {
                    PWMOnBackground scoringModel = pwm.onBackground(new WordwiseBackground());
                    result_part.put(sequenceWithSNP, new SingleSNPScan(scoringModel, sequenceWithSNP, pvalueCalculator, 0).affinityInfos());
                    continue;
                }
                System.err.println("Can't scan sequence '" + sequenceWithSNP + "' (length " + sequenceWithSNP.length() + ") with motif of length " + pwm.length());
            }
            results.put(pwmName, result_part);
        }
        for (String pwmName : results.keySet()) {
            for (SequenceWithSNP seq : ((Map)results.get(pwmName)).keySet()) {
                SingleSNPScan.RegionAffinityInfos affinityInfos = (SingleSNPScan.RegionAffinityInfos)((Map)results.get(pwmName)).get(seq);
                System.out.println(pwmName + " " + seq.toString() + " " + affinityInfos.toString());
            }
        }
    }
}

