/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.perfectosape.model.encoded.di;

import java.util.List;
import ru.autosome.perfectosape.model.encoded.EncodedSequenceWithSNVType;
import ru.autosome.perfectosape.model.encoded.di.SequenceDiEncoded;

public class SequenceWithSNPDiEncoded
implements EncodedSequenceWithSNVType<SequenceDiEncoded> {
    private final List<SequenceDiEncoded> sequenceVariants;
    private final int length;

    public SequenceWithSNPDiEncoded(List<SequenceDiEncoded> sequenceVariants) {
        if (sequenceVariants.size() < 2) {
            throw new IllegalArgumentException("There should be at least two sequences in SequenceWithSNVMonoEncoded");
        }
        this.length = sequenceVariants.get(0).length();
        for (int i = 1; i < sequenceVariants.size(); ++i) {
            if (sequenceVariants.get(i).length() == this.length) continue;
            throw new IllegalArgumentException("All sequences should be of equal length");
        }
        this.sequenceVariants = sequenceVariants;
    }

    @Override
    public SequenceDiEncoded sequenceVariant(int alleleNumber) {
        return this.sequenceVariants.get(alleleNumber);
    }

    @Override
    public int length() {
        return this.length + 1;
    }
}

