/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.ape.calculation.findPvalue;

import java.util.ArrayList;
import java.util.List;
import ru.autosome.ape.calculation.findPvalue.CanFindPvalue;
import ru.autosome.ape.calculation.findPvalue.FindPvalueExact;
import ru.autosome.ape.calculation.findPvalue.FoundedPvalueInfo;
import ru.autosome.commons.backgroundModel.GeneralizedBackgroundModel;
import ru.autosome.commons.cli.ReportListLayout;
import ru.autosome.commons.model.Discretizer;
import ru.autosome.commons.motifModel.Discretable;
import ru.autosome.commons.motifModel.HasLength;

public class FindPvalueAPE<ModelType extends Discretable<ModelType> & HasLength, BackgroundType extends GeneralizedBackgroundModel>
implements CanFindPvalue {
    final FindPvalueExact<ModelType, BackgroundType> pvalueCalculator;
    final Discretizer discretizer;

    public FindPvalueAPE(ModelType motif, BackgroundType background, Discretizer discretizer) {
        this.pvalueCalculator = new FindPvalueExact<HasLength, BackgroundType>((HasLength)motif.discrete(discretizer), background);
        this.discretizer = discretizer;
    }

    @Override
    public List<FoundedPvalueInfo> pvaluesByThresholds(List<Double> thresholds) {
        List<FoundedPvalueInfo> infos_upscaled = this.pvalueCalculator.pvaluesByThresholds(this.discretizer.upscale(thresholds));
        ArrayList<FoundedPvalueInfo> infos = new ArrayList<FoundedPvalueInfo>();
        for (FoundedPvalueInfo info_upscaled : infos_upscaled) {
            infos.add(info_upscaled.downscale(this.discretizer));
        }
        return infos;
    }

    @Override
    public FoundedPvalueInfo pvalueByThreshold(double threshold) {
        ArrayList<Double> thresholds = new ArrayList<Double>();
        thresholds.add(threshold);
        return this.pvaluesByThresholds(thresholds).get(0);
    }

    @Override
    public ReportListLayout<FoundedPvalueInfo> report_table_layout() {
        ReportListLayout<FoundedPvalueInfo> layout = this.pvalueCalculator.report_table_layout();
        layout.add_parameter("V", "discretization value", this.discretizer);
        return layout;
    }
}

