/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.commons.cli;

import java.util.ArrayList;
import java.util.List;
import ru.autosome.commons.cli.ListReporter;
import ru.autosome.commons.cli.ParameterDescription;
import ru.autosome.commons.cli.ReportListLayout;
import ru.autosome.commons.cli.ValueWithDescription;
import ru.autosome.commons.support.StringExtensions;

public class TextListReporter<ResultInfo>
implements ListReporter<ResultInfo> {
    @Override
    public String report(List<ResultInfo> data, ReportListLayout<ResultInfo> layout) {
        ArrayList<String> sections = new ArrayList<String>();
        sections.add(this.formatParameter(layout.parameters));
        sections.add(this.formatTable(layout.columns, data));
        ArrayList<String> results = new ArrayList<String>();
        for (String section : sections) {
            if (section.isEmpty()) continue;
            results.add(section);
        }
        return StringExtensions.join(results, "\n#\n");
    }

    protected String parameter_description_string(String param_name, String description) {
        return "# " + param_name + ": " + description;
    }

    protected String formatParameter(List<ValueWithDescription> parameters) {
        ArrayList<String> descriptions = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        for (ValueWithDescription parameter : parameters) {
            if (parameter.description != null) {
                descriptions.add(this.parameter_description_string(parameter.name, parameter.description));
            }
            values.add("# " + parameter.name + " = " + parameter.value);
        }
        return StringExtensions.glueSections(StringExtensions.join(descriptions, "\n"), StringExtensions.join(values, "\n"));
    }

    protected String formatRow(List<ParameterDescription<ResultInfo>> columns, ResultInfo rowData) {
        ArrayList<String> rowCells = new ArrayList<String>();
        for (ParameterDescription<ResultInfo> parameter : columns) {
            rowCells.add(parameter.callback.apply(rowData).toString());
        }
        return StringExtensions.join(rowCells, "\t");
    }

    protected String formatTable(List<ParameterDescription<ResultInfo>> columns, List<ResultInfo> data) {
        if (data == null) {
            return "";
        }
        ArrayList<String> descriptionRows = new ArrayList<String>();
        ArrayList<String> table_headers = new ArrayList<String>();
        for (ParameterDescription<ResultInfo> parameter : columns) {
            if (parameter.description != null) {
                descriptionRows.add(this.parameter_description_string(parameter.name, parameter.description));
            }
            table_headers.add(parameter.name);
        }
        String header = "";
        if (!table_headers.isEmpty()) {
            header = "# " + StringExtensions.join(table_headers, "\t");
        }
        ArrayList<String> tableRows = new ArrayList<String>();
        for (ResultInfo row : data) {
            tableRows.add(this.formatRow(columns, row));
        }
        return StringExtensions.glueSections(StringExtensions.join(descriptionRows, "\n"), header, StringExtensions.join(tableRows, "\n"));
    }
}

