/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.commons.importer;

import java.util.ArrayList;
import java.util.List;

public class MotifSplitter {
    public final String splitter_pattern;
    public final String first_line_pattern;

    MotifSplitter(String splitter_pattern, String first_line_pattern) {
        this.splitter_pattern = splitter_pattern;
        this.first_line_pattern = first_line_pattern;
    }

    public List<List<String>> split(List<String> strings) {
        ArrayList<List<String>> result = new ArrayList<List<String>>();
        ArrayList<String> chunk = new ArrayList<String>();
        for (String string : strings) {
            if (string.matches(this.splitter_pattern)) {
                if (!chunk.isEmpty()) {
                    result.add(chunk);
                }
                chunk = new ArrayList();
                continue;
            }
            if (string.matches(this.first_line_pattern)) {
                if (!chunk.isEmpty()) {
                    result.add(chunk);
                }
                chunk = new ArrayList();
                chunk.add(string);
                continue;
            }
            chunk.add(string);
        }
        if (!chunk.isEmpty()) {
            result.add(chunk);
        }
        return result;
    }
}

