/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.commons.model;

import java.util.ArrayList;
import java.util.List;

public class Discretizer {
    public final Double discretization;

    public Discretizer(Double discretization) {
        this.discretization = discretization;
    }

    public static Discretizer fromString(String s) {
        return new Discretizer(Double.valueOf(s));
    }

    public double upscale(double value) {
        if (this.discretization == null) {
            return value;
        }
        return value * this.discretization;
    }

    public List<Double> upscale(List<Double> values) {
        ArrayList<Double> result = new ArrayList<Double>();
        for (Double value : values) {
            result.add(this.upscale(value));
        }
        return result;
    }

    public double downscale(double value) {
        if (this.discretization == null) {
            return value;
        }
        return value / this.discretization;
    }

    public double discrete(double value) {
        if (this.discretization == null) {
            return value;
        }
        return Math.ceil(value * this.discretization);
    }

    public String toString() {
        return this.discretization.toString();
    }
}

