/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.macroape.model;

import ru.autosome.commons.model.Orientation;
import ru.autosome.commons.model.Position;
import ru.autosome.commons.motifModel.Alignable;

public class PairAligned<ModelType extends Alignable<ModelType>> {
    public final ModelType firstModelAligned;
    public final ModelType secondModelAligned;
    protected final Position relative_position;
    private final int first_length;
    private final int second_length;

    public PairAligned(ModelType first_model_unaligned, ModelType second_model_unaligned, Position relative_position) {
        this.first_length = first_model_unaligned.length();
        this.second_length = second_model_unaligned.length();
        this.relative_position = relative_position;
        Object first_tmp = first_model_unaligned;
        Object second_tmp = second_model_unaligned;
        if (this.isReverseComplement()) {
            second_tmp = (Alignable)second_tmp.reverseComplement();
        }
        if (this.shift() > 0) {
            second_tmp = (Alignable)second_tmp.leftAugment(this.shift());
        } else {
            first_tmp = (Alignable)first_tmp.leftAugment(-this.shift());
        }
        this.firstModelAligned = (Alignable)first_tmp.rightAugment(this.length() - first_tmp.length());
        this.secondModelAligned = (Alignable)second_tmp.rightAugment(this.length() - second_tmp.length());
    }

    public int shift() {
        return this.relative_position.position();
    }

    public Orientation orientation() {
        return this.relative_position.orientation();
    }

    public int length() {
        if (this.shift() > 0) {
            return Math.max(this.first_length, this.second_length + this.shift());
        }
        return Math.max(this.first_length - this.shift(), this.second_length);
    }

    public boolean isDirect() {
        return this.relative_position.isDirect();
    }

    public boolean isReverseComplement() {
        return this.relative_position.isReverseComplement();
    }

    private boolean isFirstOverlapsPosition(int position) {
        if (position < 0 || position >= this.length()) {
            return false;
        }
        if (this.shift() > 0) {
            return position < this.first_length;
        }
        return position >= -this.shift() && position < -this.shift() + this.first_length;
    }

    private boolean isSecondOverlapsPosition(int position) {
        if (position < 0 || position >= this.length()) {
            return false;
        }
        if (this.shift() > 0) {
            return position >= this.shift() && position < this.shift() + this.second_length;
        }
        return position < this.second_length;
    }

    public int overlapSize() {
        int sum = 0;
        for (int pos = 0; pos < this.length(); ++pos) {
            if (!this.isFirstOverlapsPosition(pos) || !this.isSecondOverlapsPosition(pos)) continue;
            ++sum;
        }
        return sum;
    }

    public String first_model_alignment() {
        StringBuilder builder = new StringBuilder();
        for (int pos = 0; pos < this.length(); ++pos) {
            if (this.isFirstOverlapsPosition(pos)) {
                builder.append('>');
                continue;
            }
            builder.append('.');
        }
        return builder.toString();
    }

    public String second_model_alignment() {
        StringBuilder builder = new StringBuilder();
        for (int pos = 0; pos < this.length(); ++pos) {
            if (this.isSecondOverlapsPosition(pos)) {
                if (this.isDirect()) {
                    builder.append('>');
                    continue;
                }
                builder.append('<');
                continue;
            }
            builder.append('.');
        }
        return builder.toString();
    }

    public String toString() {
        return this.first_model_alignment() + "\n" + this.second_model_alignment();
    }
}

