/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.perfectosape.cli.generalized;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ru.autosome.ape.calculation.findPvalue.CanFindPvalue;
import ru.autosome.ape.calculation.findPvalue.FindPvalueAPE;
import ru.autosome.ape.calculation.findPvalue.FindPvalueBsearch;
import ru.autosome.commons.backgroundModel.GeneralizedBackgroundModel;
import ru.autosome.commons.cli.Helper;
import ru.autosome.commons.model.Discretizer;
import ru.autosome.commons.model.Named;
import ru.autosome.commons.model.PseudocountCalculator;
import ru.autosome.commons.motifModel.BackgroundAppliable;
import ru.autosome.commons.motifModel.Discretable;
import ru.autosome.commons.motifModel.HasLength;
import ru.autosome.commons.motifModel.types.DataModel;
import ru.autosome.commons.scoringModel.SequenceScoringModel;
import ru.autosome.perfectosape.calculation.SingleSNVScan;
import ru.autosome.perfectosape.model.RegionAffinityInfos;
import ru.autosome.perfectosape.model.SequenceWithSNV;
import ru.autosome.perfectosape.model.ThresholdEvaluator;
import ru.autosome.perfectosape.model.encoded.EncodedSequenceType;
import ru.autosome.perfectosape.model.encoded.EncodedSequenceWithSNVType;

public abstract class SNPScan<SequenceType extends EncodedSequenceType & HasLength, SequenceWithSNVType extends EncodedSequenceWithSNVType<SequenceType>, MotifType extends HasLength & Discretable<MotifType> & BackgroundAppliable<BackgroundType, ModelType>, ModelType extends SequenceScoringModel<SequenceType>, BackgroundType extends GeneralizedBackgroundModel> {
    protected Discretizer discretizer;
    protected int expand_region_length;
    protected File path_to_collection_of_pwms;
    protected File path_to_file_w_snps;
    protected DataModel dataModel;
    protected double effectiveCount;
    protected PseudocountCalculator pseudocount;
    protected File thresholds_folder;
    protected List<ThresholdEvaluator<SequenceType, ModelType>> pwmCollection;
    protected double max_pvalue_cutoff;
    protected Double min_fold_change_cutoff;
    protected BackgroundType background;
    protected boolean transpose;
    protected boolean shortFormat;
    protected boolean useLogFoldChange;
    protected boolean printHeader;

    protected abstract void initialize_default_background();

    protected abstract void extract_background(String var1);

    protected abstract List<Named<MotifType>> load_collection_of_pwms();

    protected void load_collection_of_pwms_with_evaluators() throws FileNotFoundException {
        List<Named<MotifType>> motifList = this.load_collection_of_pwms();
        this.pwmCollection = new ArrayList<ThresholdEvaluator<SequenceType, ModelType>>();
        for (Named<MotifType> motif : motifList) {
            CanFindPvalue pvalueCalculator;
            if (this.thresholds_folder == null) {
                pvalueCalculator = new FindPvalueAPE<Discretable, BackgroundType>((Discretable)motif.getObject(), this.background, this.discretizer);
            } else {
                File thresholds_file = new File(this.thresholds_folder, motif.getName() + ".thr");
                pvalueCalculator = new FindPvalueBsearch(thresholds_file);
            }
            this.pwmCollection.add(new ThresholdEvaluator((SequenceScoringModel)((BackgroundAppliable)((Object)((HasLength)motif.getObject()))).onBackground(this.background), pvalueCalculator, motif.getName()));
        }
    }

    protected abstract String DOC_background_option();

    protected abstract String DOC_run_string();

    protected String documentString() {
        return "Command-line format:\n" + this.DOC_run_string() + " <folder with pwms> <file with SNPs> [options]\n\nOptions:\n  [--pvalue-cutoff <maximal pvalue to be considered>] or [-P] - drop results having both allele-variant pvalues greater than given\n                                                       (default: 0.0005)\n  [--fold-change-cutoff <minimal fold change to be considered>] or [-F] - drop results having fold change (both 1st pvalue to 2nd, 2nd to 1st)\n                                                                 less than given (default: 4 in linear scale or 2 in log-scale)\n        In order to get all fold changes - set both pvalue-cutoff and fold-change-cutoff to 1.0.\n  [--discretization <discretization level>] or [-d]\n  [--pcm] - treat the input file as Position Count Matrix. PCM-to-PWM transformation to be done internally.\n  [--ppm] or [--pfm] - treat the input file as Position Frequency Matrix. PPM-to-PWM transformation to be done internally.\n  [--effective-count <count>] - effective samples set size for PPM-to-PWM conversion (default: 100). \n  [--background <background probabilities>] or [-b] " + this.DOC_background_option() + "\n  [--precalc <folder>] - specify folder with thresholds for PWM collection (for fast-and-rough calculation).\n  [--transpose] - load motif from transposed matrix (nucleotides in lines).\n  [--expand-region <length>] - expand the region to scan for PWM hits by <length> positions\n                               from each side allowing PWM to be located nearby but not necessarily\n                               overlap the nucleotide substitution position.\n  [--compact] - use compact output format.\n  [--log-fold-change] - use logarithmic (log2) fold change scale (both in output and in cutoff setup).\n  [--without-header] - don't print results table header\n" + this.DOC_additional_options() + "\nExamples:\n  " + this.DOC_run_string() + " ./hocomoco/pwms/ snp.txt --precalc ./collection_thresholds\n  " + this.DOC_run_string() + " ./hocomoco/pcms/ snp.txt --pcm -d 10\n";
    }

    protected String DOC_additional_options() {
        return "";
    }

    void extract_path_to_collection_of_pwms(List<String> argv) {
        try {
            this.path_to_collection_of_pwms = new File(argv.remove(0));
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Specify PWM-collection folder", e);
        }
    }

    void extract_path_to_file_w_snps(List<String> argv) {
        try {
            this.path_to_file_w_snps = new File(argv.remove(0));
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Specify file with SNPs", e);
        }
    }

    protected void initialize_defaults() {
        this.initialize_default_background();
        this.discretizer = new Discretizer(100.0);
        this.expand_region_length = 0;
        this.dataModel = DataModel.PWM;
        this.effectiveCount = 100.0;
        this.pseudocount = PseudocountCalculator.logPseudocount;
        this.thresholds_folder = null;
        this.max_pvalue_cutoff = 5.0E-4;
        this.min_fold_change_cutoff = null;
        this.transpose = false;
        this.shortFormat = false;
        this.useLogFoldChange = false;
        this.printHeader = true;
    }

    protected SNPScan() {
        this.initialize_defaults();
    }

    protected void setup_from_arglist(String[] args) throws FileNotFoundException {
        ArrayList<String> argv = new ArrayList<String>();
        Collections.addAll(argv, args);
        this.setup_from_arglist(argv);
    }

    protected void setup_from_arglist(List<String> argv) throws FileNotFoundException {
        Helper.print_help_if_requested(argv, this.documentString());
        this.extract_path_to_collection_of_pwms(argv);
        this.extract_path_to_file_w_snps(argv);
        while (argv.size() > 0) {
            this.extract_option(argv);
        }
        if (this.useLogFoldChange) {
            this.min_fold_change_cutoff = this.min_fold_change_cutoff == null ? Double.valueOf(2.0) : Double.valueOf(Math.abs(this.min_fold_change_cutoff));
        } else if (this.min_fold_change_cutoff == null) {
            this.min_fold_change_cutoff = 4.0;
        } else if (this.min_fold_change_cutoff < 1.0) {
            this.min_fold_change_cutoff = 1.0 / this.min_fold_change_cutoff;
        }
        this.load_collection_of_pwms_with_evaluators();
    }

    protected void extract_option(List<String> argv) throws FileNotFoundException {
        String opt = argv.remove(0);
        if (opt.equals("-b") || opt.equals("--background")) {
            this.extract_background(argv.remove(0));
        } else if (opt.equals("-d") || opt.equals("--discretization")) {
            this.discretizer = Discretizer.fromString(argv.remove(0));
        } else if (opt.equals("--pcm")) {
            this.dataModel = DataModel.PCM;
        } else if (opt.equals("--ppm") || opt.equals("--pfm")) {
            this.dataModel = DataModel.PPM;
        } else if (opt.equals("--effective-count")) {
            this.effectiveCount = Double.valueOf(argv.remove(0));
        } else if (opt.equals("--pseudocount")) {
            this.pseudocount = PseudocountCalculator.fromString(argv.remove(0));
        } else if (opt.equals("--precalc")) {
            this.thresholds_folder = new File(argv.remove(0));
            if (!this.thresholds_folder.exists()) {
                throw new FileNotFoundException("Specified folder with thresholds `" + this.thresholds_folder + "` not exists");
            }
            if (!this.thresholds_folder.isDirectory()) {
                throw new FileNotFoundException("`" + this.thresholds_folder + "` is not a directory");
            }
        } else if (opt.equals("--pvalue-cutoff") || opt.equals("-P")) {
            this.max_pvalue_cutoff = Double.valueOf(argv.remove(0));
        } else if (opt.equals("--fold-change-cutoff") || opt.equals("-F")) {
            this.min_fold_change_cutoff = Double.valueOf(argv.remove(0));
        } else if (opt.equals("--transpose")) {
            this.transpose = true;
        } else if (opt.equals("--expand-region")) {
            this.expand_region_length = Integer.valueOf(argv.remove(0));
        } else if (opt.equals("--compact")) {
            this.shortFormat = true;
        } else if (opt.equals("--log-fold-change")) {
            this.useLogFoldChange = true;
        } else if (opt.equals("--without-header")) {
            this.printHeader = false;
        } else if (this.failed_to_recognize_additional_options(opt, argv)) {
            throw new IllegalArgumentException("Unknown option '" + opt + "'");
        }
    }

    protected boolean failed_to_recognize_additional_options(String opt, List<String> argv) {
        return true;
    }

    protected abstract SequenceWithSNVType encodeSequenceWithSNV(SequenceWithSNV var1);

    private boolean pvalueSignificant(RegionAffinityInfos affinityInfos) {
        return affinityInfos.hasSiteOnAnyAllele(this.max_pvalue_cutoff);
    }

    private boolean foldChangeSignificant(RegionAffinityInfos affinityInfos) {
        if (this.useLogFoldChange) {
            double logFoldChange = affinityInfos.logFoldChange();
            return logFoldChange >= this.min_fold_change_cutoff || logFoldChange <= -this.min_fold_change_cutoff.doubleValue();
        }
        double foldChange = affinityInfos.foldChange();
        return foldChange >= this.min_fold_change_cutoff || foldChange <= 1.0 / this.min_fold_change_cutoff;
    }

    private boolean affinityChangeSignificant(RegionAffinityInfos affinityInfos) {
        return this.pvalueSignificant(affinityInfos) && this.foldChangeSignificant(affinityInfos);
    }

    protected void process_snp(String snp_name, SequenceWithSNV seq_w_snp, SequenceWithSNVType encodedSequenceWithSNP) {
        for (ThresholdEvaluator<SequenceType, ModelType> motifEvaluator : this.pwmCollection) {
            Object pwm = motifEvaluator.pwm;
            if (seq_w_snp.length() >= pwm.length()) {
                RegionAffinityInfos affinityInfos = new SingleSNVScan(pwm, seq_w_snp, encodedSequenceWithSNP, motifEvaluator.pvalueCalculator, this.expand_region_length).affinityInfos();
                if (!this.affinityChangeSignificant(affinityInfos)) continue;
                if (this.shortFormat) {
                    System.out.println(snp_name + "\t" + motifEvaluator.name + "\t" + affinityInfos.toStringShort());
                    continue;
                }
                System.out.println(snp_name + "\t" + motifEvaluator.name + "\t" + affinityInfos.toString(this.useLogFoldChange));
                continue;
            }
            System.err.println("Can't scan sequence '" + seq_w_snp + "' (length " + seq_w_snp.length() + ") with motif of length " + pwm.length());
        }
    }

    public void process() throws IOException {
        if (this.printHeader) {
            if (this.shortFormat) {
                System.out.println("# SNP name\tmotif\tP-value 1\tP-value 2\tposition 1\torientation 1\tposition 2\torientation 2");
            } else if (this.useLogFoldChange) {
                System.out.println("# SNP name\tmotif\tposition 1\torientation 1\tword 1\tposition 2\torientation 2\tword 2\tallele 1/allele 2\tP-value 1\tP-value 2\tFold change (log2 scale)");
            } else {
                System.out.println("# SNP name\tmotif\tposition 1\torientation 1\tword 1\tposition 2\torientation 2\tword 2\tallele 1/allele 2\tP-value 1\tP-value 2\tFold change");
            }
        }
        int necessaryLength = this.necessaryFlankLength();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(this.path_to_file_w_snps)));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.trim().isEmpty() || line.charAt(0) == '#') continue;
                String[] input_parts = line.split("\\s+", 3);
                String snp_name = input_parts[0];
                SequenceWithSNV seq_w_snp = SequenceWithSNV.fromString(input_parts[1]);
                SequenceWithSNV seq_extended = seq_w_snp.expandFlanksUpTo(necessaryLength);
                this.process_snp(snp_name, seq_extended, this.encodeSequenceWithSNV(seq_extended));
            }
        }
    }

    int necessaryFlankLength() {
        int maxMotifLength = 1;
        for (ThresholdEvaluator<SequenceType, ModelType> evaluator : this.pwmCollection) {
            maxMotifLength = Math.max(maxMotifLength, evaluator.pwm.length());
        }
        return maxMotifLength + this.expand_region_length;
    }
}

