/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.perfectosape.model.encoded.mono;

import ru.autosome.commons.model.Alphabet;
import ru.autosome.perfectosape.model.Sequence;
import ru.autosome.perfectosape.model.encoded.EncodedSequenceType;

public class SequenceMonoEncoded
implements EncodedSequenceType {
    public final byte[] directSequence;
    public final byte[] revcompSequence;

    public SequenceMonoEncoded(byte[] directSequence, byte[] revcompSequence) {
        if (directSequence.length != revcompSequence.length) {
            throw new IllegalArgumentException("direct and revcomp sequences should be of equal length");
        }
        this.directSequence = directSequence;
        this.revcompSequence = revcompSequence;
    }

    @Override
    public int length() {
        return this.directSequence.length;
    }

    public String toString() {
        return Alphabet.monoACGTN.decodeString(this.directSequence);
    }

    public static SequenceMonoEncoded encode(Sequence sequenceToEncode) {
        byte[] directSeq = Alphabet.monoACGTN.convertString(sequenceToEncode.sequenceString());
        byte[] revcompSeq = Alphabet.monoACGTN.convertString(sequenceToEncode.reverseComplementString());
        return new SequenceMonoEncoded(directSeq, revcompSeq);
    }
}

