/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.ape.calculation.findPvalue;

import gnu.trove.map.TDoubleDoubleMap;
import java.util.ArrayList;
import java.util.List;
import ru.autosome.ape.calculation.ScoringModelDistributions.ScoringDistributionGenerator;
import ru.autosome.ape.calculation.findPvalue.CanFindPvalue;
import ru.autosome.ape.calculation.findPvalue.FoundedPvalueInfo;
import ru.autosome.commons.backgroundModel.GeneralizedBackgroundModel;
import ru.autosome.commons.cli.ReportListLayout;
import ru.autosome.commons.motifModel.HasLength;
import ru.autosome.commons.motifModel.ScoreDistribution;

public class FindPvalueExact<ModelType extends HasLength & ScoreDistribution<BackgroundType>, BackgroundType extends GeneralizedBackgroundModel>
implements CanFindPvalue {
    final ModelType motif;
    final BackgroundType background;

    public FindPvalueExact(ModelType motif, BackgroundType background) {
        this.motif = motif;
        this.background = background;
    }

    @Override
    public List<FoundedPvalueInfo> pvaluesByThresholds(List<Double> thresholds) {
        double vocabularyVolume = Math.pow(this.background.volume(), this.motif.length());
        ScoringDistributionGenerator scoringModel = ((ScoreDistribution)this.motif).scoringModel(this.background);
        TDoubleDoubleMap counts = scoringModel.counts_above_thresholds(thresholds);
        ArrayList<FoundedPvalueInfo> infos = new ArrayList<FoundedPvalueInfo>();
        for (double threshold : thresholds) {
            double count = counts.get(threshold);
            double pvalue = count / vocabularyVolume;
            infos.add(new FoundedPvalueInfo(threshold, pvalue));
        }
        return infos;
    }

    @Override
    public FoundedPvalueInfo pvalueByThreshold(double threshold) {
        ArrayList<Double> thresholds = new ArrayList<Double>();
        thresholds.add(threshold);
        return this.pvaluesByThresholds(thresholds).get(0);
    }

    @Override
    public ReportListLayout<FoundedPvalueInfo> report_table_layout() {
        ReportListLayout<FoundedPvalueInfo> layout = new ReportListLayout<FoundedPvalueInfo>();
        layout.background_parameter("B", "background", (GeneralizedBackgroundModel)this.background);
        layout.add_table_parameter("T", "threshold", cell -> cell.threshold);
        if (this.background.is_wordwise()) {
            layout.add_table_parameter("W", "number of recognized words", cell -> {
                double numberOfRecognizedWords = cell.numberOfRecognizedWords(this.background.volume(), this.motif.length());
                return (long)numberOfRecognizedWords;
            });
        }
        layout.add_table_parameter("P", "P-value", cell -> cell.pvalue);
        return layout;
    }
}

