/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.macroape.model;

import ru.autosome.commons.model.Orientation;
import ru.autosome.macroape.model.PairAligned;

public class ComparisonSimilarityInfo {
    public final PairAligned alignment;
    public final double recognizedByBoth;
    public final double recognizedByFirst;
    public final double recognizedBySecond;

    public ComparisonSimilarityInfo(PairAligned alignment, double recognizedByBoth, double recognizedByFirst, double recognizedBySecond) {
        this.recognizedByFirst = recognizedByFirst;
        this.recognizedBySecond = recognizedBySecond;
        this.recognizedByBoth = recognizedByBoth;
        this.alignment = alignment;
    }

    public Double realPvalueFirst(int backgroundVolume) {
        double vocabularyVolume = Math.pow(backgroundVolume, this.alignment.length());
        return this.recognizedByFirst / vocabularyVolume;
    }

    public Double realPvalueSecond(int backgroundVolume) {
        double vocabularyVolume = Math.pow(backgroundVolume, this.alignment.length());
        return this.recognizedBySecond / vocabularyVolume;
    }

    public int shift() {
        return this.alignment.shift();
    }

    public Orientation orientation() {
        return this.alignment.orientation();
    }

    public int overlap() {
        return this.alignment.overlapSize();
    }

    public static Double jaccardByCounts(double recognizedByFirst, double recognizedBySecond, double recognizedByBoth) {
        if (recognizedByFirst == 0.0 || recognizedBySecond == 0.0) {
            return null;
        }
        double union = recognizedByFirst + recognizedBySecond - recognizedByBoth;
        return recognizedByBoth / union;
    }

    public Double similarity() {
        return ComparisonSimilarityInfo.jaccardByCounts(this.recognizedByFirst, this.recognizedBySecond, this.recognizedByBoth);
    }

    public Double distance() {
        Double similarity = this.similarity();
        if (similarity == null) {
            return null;
        }
        return 1.0 - similarity;
    }

    public int length() {
        return this.alignment.length();
    }

    public String first_model_alignment() {
        return this.alignment.first_model_alignment();
    }

    public String second_model_alignment() {
        return this.alignment.second_model_alignment();
    }

    public double getRecognizedByBoth() {
        return this.recognizedByBoth;
    }

    public double getRecognizedByFirst() {
        return this.recognizedByFirst;
    }

    public double getRecognizedBySecond() {
        return this.recognizedBySecond;
    }
}

