/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.ape.calculation.ScoringModelDistributions;

import gnu.trove.iterator.TDoubleDoubleIterator;
import gnu.trove.map.TDoubleDoubleMap;
import gnu.trove.map.hash.TDoubleDoubleHashMap;
import ru.autosome.ape.calculation.ScoringModelDistributions.ScoringDistributionGenerator;
import ru.autosome.ape.calculation.findThreshold.GaussianThresholdEstimator;
import ru.autosome.ape.model.ScoreDistributionTop;
import ru.autosome.commons.backgroundModel.mono.BackgroundModel;
import ru.autosome.commons.motifModel.mono.PWM;
import ru.autosome.commons.scoringModel.PWMSequenceScoring;

public class PWMScoresGenerator
extends ScoringDistributionGenerator {
    final PWM pwm;
    final BackgroundModel background;

    public PWMScoresGenerator(PWM pwm, BackgroundModel background) {
        this.pwm = pwm;
        this.background = background;
    }

    @Override
    GaussianThresholdEstimator<PWMSequenceScoring> gaussianThresholdEstimator() {
        return new GaussianThresholdEstimator<PWMSequenceScoring>(this.pwm.onBackground(this.background));
    }

    protected TDoubleDoubleMap initialCountDistribution() {
        TDoubleDoubleHashMap scores = new TDoubleDoubleHashMap();
        scores.put(0.0, 1.0);
        return scores;
    }

    @Override
    protected ScoreDistributionTop score_distribution_above_threshold(double threshold) {
        TDoubleDoubleMap scores = this.initialCountDistribution();
        for (int pos = 0; pos < this.pwm.length(); ++pos) {
            scores = this.recalc_score_hash(scores, this.pwm.getMatrix()[pos], threshold - this.pwm.best_suffix(pos + 1));
        }
        ScoreDistributionTop result = new ScoreDistributionTop(scores, this.vocabularyVolume(), threshold);
        result.setWorstScore(this.pwm.worst_score());
        result.setBestScore(this.pwm.best_score());
        return result;
    }

    private TDoubleDoubleMap recalc_score_hash(TDoubleDoubleMap scores, double[] column, double least_sufficient) {
        TDoubleDoubleHashMap new_scores = new TDoubleDoubleHashMap(scores.size());
        TDoubleDoubleIterator iterator = scores.iterator();
        while (iterator.hasNext()) {
            iterator.advance();
            double score = iterator.key();
            double count = iterator.value();
            for (int letter = 0; letter < 4; ++letter) {
                double new_score = score + column[letter];
                if (!(new_score >= least_sufficient)) continue;
                double add = count * this.background.count(letter);
                new_scores.adjustOrPutValue(new_score, add, add);
            }
        }
        return new_scores;
    }

    private double vocabularyVolume() {
        return Math.pow(this.background.volume(), this.pwm.length());
    }
}

