/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.ape.calculation.findThreshold;

import ru.autosome.commons.motifModel.ScoreStatistics;
import ru.autosome.commons.support.MathExtensions;

public class GaussianThresholdEstimator<ModelType extends ScoreStatistics> {
    final ModelType scoringModel;

    public GaussianThresholdEstimator(ModelType scoringModel) {
        this.scoringModel = scoringModel;
    }

    public double thresholdByPvalue(double pvalue) {
        double sigma = Math.sqrt(this.scoringModel.score_variance());
        double n_ = MathExtensions.inverf(1.0 - 2.0 * pvalue) * Math.sqrt(2.0);
        return this.scoringModel.score_mean() + n_ * sigma;
    }
}

