/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.commons.importer;

import java.util.ArrayList;
import java.util.List;
import ru.autosome.commons.importer.InputExtensions;
import ru.autosome.commons.importer.ParsingResult;
import ru.autosome.commons.support.StringExtensions;

public class ChIPMunkParser {
    public final int alphabet_size;
    public final String section;
    public final String matrix_start;

    public ChIPMunkParser(int alphabet_size, String section, String matrix_start) {
        this.section = section;
        this.matrix_start = matrix_start;
        this.alphabet_size = alphabet_size;
    }

    public ParsingResult parse(List<String> strings) {
        ArrayList<double[]> matrix = new ArrayList<double[]>();
        int start = (strings = InputExtensions.trimAll(strings)).lastIndexOf("OUTC|" + this.section);
        if (start == -1) {
            throw new RuntimeException("Corrupted ChIPMunk output detected.");
        }
        for (int lineNumber = start; lineNumber < strings.size(); ++lineNumber) {
            if (!StringExtensions.startWith(strings.get(lineNumber), this.matrix_start)) continue;
            int lengthOfMotif = strings.get(lineNumber).split("\\s+").length;
            for (int positionIndex = 0; positionIndex < lengthOfMotif; ++positionIndex) {
                matrix.add(new double[this.alphabet_size]);
            }
            for (int letterIndex = 0; letterIndex < this.alphabet_size; ++letterIndex) {
                String[] weights = strings.get(letterIndex + lineNumber).split("\\|")[1].split("\\s+");
                for (int positionIndex = 0; positionIndex < lengthOfMotif; ++positionIndex) {
                    ((double[])matrix.get((int)positionIndex))[letterIndex] = Double.parseDouble(weights[positionIndex]);
                }
            }
            break;
        }
        if (matrix.size() == 0) {
            throw new RuntimeException("Corrupted ChIPMunk output detected.");
        }
        return new ParsingResult(matrix, null);
    }
}

