/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.commons.importer;

import java.util.ArrayList;
import java.util.List;
import ru.autosome.commons.importer.InputExtensions;
import ru.autosome.commons.importer.ParsingResult;

public class TransposedMatrixParser {
    public final int alphabet_size;

    public TransposedMatrixParser(int alphabet_size) {
        this.alphabet_size = alphabet_size;
    }

    String getName(List<String> strings) {
        String header = strings.get(0).trim();
        if (header.charAt(0) == '>') {
            return header.substring(1).trim();
        }
        if (!InputExtensions.startWithDouble(header)) {
            return header;
        }
        return null;
    }

    List<String> withoutHeader(List<String> strings) {
        String header = strings.get(0).trim();
        if (header.charAt(0) == '>' || !InputExtensions.startWithDouble(header)) {
            return strings.subList(1, strings.size());
        }
        return strings;
    }

    List<String> beforeEmptyLine(List<String> lines) {
        ArrayList<String> result = new ArrayList<String>();
        for (String line : lines) {
            if (line.trim().isEmpty()) {
                return result;
            }
            result.add(line);
        }
        return result;
    }

    public ParsingResult parse(List<String> strings) {
        String name = this.getName(strings);
        strings = this.beforeEmptyLine(this.withoutHeader(strings));
        ArrayList<double[]> matrix = new ArrayList<double[]>();
        if (strings.size() != this.alphabet_size) {
            throw new RuntimeException("Incorrect number of weight lines in the transposed matrix input file.");
        }
        int lenghtOfMotif = strings.get(0).split("\\s+").length;
        for (int positionIndex = 0; positionIndex < lenghtOfMotif; ++positionIndex) {
            matrix.add(new double[this.alphabet_size]);
        }
        for (int letterIndex = 0; letterIndex < this.alphabet_size; ++letterIndex) {
            String[] weights = strings.get(letterIndex).split("\\s+");
            if (weights.length != lenghtOfMotif) {
                throw new RuntimeException("Different number of elements in positions of transposed matrix input file.");
            }
            for (int positionIndex = 0; positionIndex < lenghtOfMotif; ++positionIndex) {
                ((double[])matrix.get((int)positionIndex))[letterIndex] = Double.parseDouble(weights[positionIndex]);
            }
        }
        return new ParsingResult(matrix, name);
    }
}

