/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.commons.model;

public abstract class PseudocountCalculator {
    public static final PseudocountCalculator logPseudocount = new PseudocountCalculator(){

        @Override
        public Double calculatePseudocount(double count) {
            return Math.log(Math.max(count, 2.0));
        }
    };
    public static final PseudocountCalculator sqrtPseudocount = new PseudocountCalculator(){

        @Override
        public Double calculatePseudocount(double count) {
            return Math.sqrt(count);
        }
    };

    public abstract Double calculatePseudocount(double var1);

    public static PseudocountCalculator constPseudocount(final double pseudocount) {
        return new PseudocountCalculator(){

            @Override
            public Double calculatePseudocount(double count) {
                return pseudocount;
            }
        };
    }

    public static PseudocountCalculator fromString(String s) {
        if (s.toLowerCase().equals("log")) {
            return logPseudocount;
        }
        if (s.toLowerCase().equals("sqrt")) {
            return sqrtPseudocount;
        }
        return PseudocountCalculator.constPseudocount(Double.valueOf(s));
    }
}

