/*
 * Decompiled with CFR 0.152.
 */
package ru.autosome.macroape.model;

import java.util.stream.Stream;
import ru.autosome.commons.model.Orientation;
import ru.autosome.commons.model.Position;
import ru.autosome.commons.motifModel.Alignable;
import ru.autosome.macroape.model.PairAligned;

public class AlignmentGenerator<ModelType extends Alignable<ModelType>> {
    private final ModelType firstModel;
    private final ModelType secondModel;

    public AlignmentGenerator(ModelType firstModel, ModelType secondModel) {
        this.firstModel = firstModel;
        this.secondModel = secondModel;
    }

    public Stream<Position> relative_positions() {
        Stream.Builder<Position> builder = Stream.builder();
        for (int shift = -this.secondModel.length(); shift <= this.firstModel.length(); ++shift) {
            builder.accept(new Position(shift, Orientation.direct));
            builder.accept(new Position(shift, Orientation.revcomp));
        }
        return builder.build();
    }

    public Stream<Position> relative_positions_fixed_strand(Orientation strand) {
        Stream.Builder<Position> builder = Stream.builder();
        for (int shift = -this.secondModel.length(); shift <= this.firstModel.length(); ++shift) {
            builder.accept(new Position(shift, strand));
        }
        return builder.build();
    }

    public PairAligned<ModelType> alignment(Position position) {
        return new PairAligned<ModelType>(this.firstModel, this.secondModel, position);
    }

    public Stream<PairAligned<ModelType>> alignments() {
        return this.relative_positions().map(this::alignment);
    }
}

